/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.sourceediting;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.FontState;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.mylyn.wikitext.parser.css.CssParser;
import org.eclipse.mylyn.wikitext.parser.css.CssRule;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.EmbeddingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.StyleConfig;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionUtils;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.EmbeddedHtml;
import org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting.MarkupCssStyleManager;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;

public class MarkupTokenScanner
implements ITokenScanner {
    private final String partitioning;
    private final List<PositionToken> tokens = new ArrayList<PositionToken>();
    private Iterator<PositionToken> tokenIter = null;
    private PositionToken currentToken = null;
    private MarkupCssStyleManager styleManager;
    private Preferences preferences;
    private final CssParser cssParser = new CssParser();
    private final Builder builder = new Builder();
    private final RGB htmlCommentColor = (RGB)EPreferences.getInstancePrefs().getPreferenceValue(EmbeddedHtml.HTML_COMMENT_COLOR_PREF);
    private final RGB htmlBackgroundColor = (RGB)EPreferences.getInstancePrefs().getPreferenceValue(EmbeddedHtml.HTML_BACKGROUND_COLOR_PREF);

    public MarkupTokenScanner(String partitioning, StyleConfig config) {
        this.partitioning = partitioning;
        this.setStyleConfig(config);
        this.reloadPreferences();
    }

    public void setStyleConfig(StyleConfig config) {
        this.styleManager = new MarkupCssStyleManager(config);
    }

    public void reloadPreferences() {
        this.preferences = WikiTextUiPlugin.getDefault().getPreferences();
    }

    public IToken nextToken() {
        if (this.tokenIter == null || !this.tokenIter.hasNext()) {
            this.currentToken = null;
            this.tokenIter = null;
            return Token.EOF;
        }
        this.currentToken = this.tokenIter.next();
        return this.currentToken;
    }

    public int getTokenOffset() {
        return this.currentToken.getOffset();
    }

    public int getTokenLength() {
        return this.currentToken.getLength();
    }

    public void setRange(IDocument document, int offset, int length) {
        block6: {
            this.tokens.clear();
            this.tokenIter = null;
            this.currentToken = null;
            try {
                this.builder.scan(document, offset, length);
            }
            catch (BreakException breakException) {
                this.builder.clearBuilder();
                break block6;
            }
            catch (BadLocationException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.builder.clearBuilder();
                    throw throwable;
                }
            }
            this.builder.clearBuilder();
        }
        this.tokenIter = this.tokens.iterator();
    }

    protected TextAttribute createTextAttribute(StyleRange styleRange) {
        int fontStyle = styleRange.fontStyle;
        if (styleRange.strikeout) {
            fontStyle |= 0x20000000;
        }
        if (styleRange.underline) {
            fontStyle |= 0x40000000;
        }
        return new TextAttribute(styleRange.foreground, styleRange.background, fontStyle, styleRange.font);
    }

    protected final String getPrefCssStyles(DocumentBuilder.SpanType spanType) {
        String key = switch (spanType) {
            case DocumentBuilder.SpanType.BOLD -> "**bold**";
            case DocumentBuilder.SpanType.CITATION -> "??citation??";
            case DocumentBuilder.SpanType.CODE -> "@code@";
            case DocumentBuilder.SpanType.DELETED -> "-deleted text-";
            case DocumentBuilder.SpanType.EMPHASIS -> "_emphasis_";
            case DocumentBuilder.SpanType.INSERTED -> "+inserted text+";
            case DocumentBuilder.SpanType.ITALIC -> "__italic__";
            case DocumentBuilder.SpanType.MONOSPACE -> "monospace";
            case DocumentBuilder.SpanType.QUOTE -> "quote";
            case DocumentBuilder.SpanType.SPAN -> "%span%";
            case DocumentBuilder.SpanType.STRONG -> "*strong*";
            case DocumentBuilder.SpanType.SUBSCRIPT -> "~subscript~";
            case DocumentBuilder.SpanType.SUPERSCRIPT -> "^superscript^";
            case DocumentBuilder.SpanType.UNDERLINED -> "underlined";
            default -> null;
        };
        return (String)this.preferences.getCssByPhraseModifierType().get(key);
    }

    protected final String getPrefCssStyles(DocumentBuilder.BlockType blockType) {
        String key = switch (blockType) {
            case DocumentBuilder.BlockType.CODE -> "bc.";
            case DocumentBuilder.BlockType.QUOTE -> "bq.";
            case DocumentBuilder.BlockType.PREFORMATTED -> "pre.";
            case DocumentBuilder.BlockType.DEFINITION_TERM -> "dt";
            default -> null;
        };
        return (String)this.preferences.getCssByBlockModifierType().get(key);
    }

    protected final String getPrefCssStyles(int headingLevel) {
        String key = Preferences.HEADING_PREFERENCES[headingLevel];
        return (String)this.preferences.getCssByBlockModifierType().get(key);
    }

    private FontState createFontState(FontState parentState, String prefCssStyles, String explCssStyle) {
        if (prefCssStyles == null && explCssStyle == null) {
            return parentState;
        }
        FontState fontState = new FontState(parentState);
        if (prefCssStyles != null) {
            this.processCssStyles(fontState, parentState, prefCssStyles);
        }
        if (explCssStyle != null) {
            this.processCssStyles(fontState, parentState, explCssStyle);
        }
        return fontState;
    }

    private FontState createHtmlFontState(FontState parentState, EmbeddingAttributes attributes) {
        FontState fontState = new FontState(parentState);
        if ((attributes.getEmbedDescr() & 0x80) != 0) {
            if (this.htmlCommentColor != null) {
                fontState.setForeground(this.htmlCommentColor);
            }
        } else if (this.htmlBackgroundColor != null) {
            fontState.setBackground(this.htmlBackgroundColor);
        }
        return fontState;
    }

    private void processCssStyles(FontState fontState, FontState parentState, String cssStyles) {
        Iterator ruleIterator = this.cssParser.createRuleIterator(cssStyles);
        while (ruleIterator.hasNext()) {
            this.styleManager.processCssStyles(fontState, parentState, (CssRule)ruleIterator.next());
        }
    }

    private void addToken(FontState fontState, int startOffset, int endOffset) {
        StyleRange styleRange = this.styleManager.createStyleRange(fontState, startOffset, endOffset - startOffset);
        TextAttribute textAttribute = this.createTextAttribute(styleRange);
        this.tokens.add(new PositionToken(textAttribute, startOffset, endOffset - startOffset));
    }

    private static class BreakException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public BreakException() {
            super("BreakScan", null, true, false);
        }
    }

    private class Builder
    extends DocumentBuilder {
        private int startOffset;
        private int endOffset;
        private int scanRestartOffset;
        private int scanCurrentOffset;
        private final ArrayDeque<FontState> scanFontStateStack = new ArrayDeque();
        private FontState nestedCodeFontState;

        private void clearBuilder() {
            this.scanFontStateStack.clear();
            this.nestedCodeFontState = null;
        }

        public void scan(IDocument document, int startOffset, int length) throws BadLocationException, BreakException {
            this.startOffset = startOffset;
            this.endOffset = startOffset + length;
            this.scanRestartOffset = this.startOffset;
            TreePartitionNode rootNode = TreePartitionUtils.getRootNode((IDocument)document, (String)MarkupTokenScanner.this.partitioning);
            TreePartitionNode node = TreePartitionUtils.getNode((IDocument)document, (String)MarkupTokenScanner.this.partitioning, (int)startOffset, (boolean)false);
            if (node != rootNode) {
                while (node.getParent() != rootNode) {
                    node = node.getParent();
                }
                this.scanRestartOffset = node.getStartOffset();
            }
            WikitextMarkupLanguage markupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)document, (String)MarkupTokenScanner.this.partitioning);
            MarkupParser2 markupParser = new MarkupParser2(markupLanguage, (DocumentBuilder)this);
            markupParser.disable(256);
            markupParser.enable(4096);
            markupParser.enable(112);
            SourceContent content = new SourceContent(0L, document.get(this.scanRestartOffset, Math.min(this.endOffset + 100, document.getLength()) - this.scanRestartOffset), this.scanRestartOffset);
            markupParser.parse(content, true);
        }

        private void updateOffset() {
            this.updateOffset(this.getLocator().getDocumentOffset());
        }

        private void updateOffset(int locatorOffset) {
            int offset = this.scanRestartOffset + locatorOffset;
            if (offset > this.scanCurrentOffset) {
                MarkupTokenScanner.this.addToken(this.scanFontStateStack.getLast(), this.scanCurrentOffset, Math.min(this.endOffset, offset));
                this.scanCurrentOffset = offset;
            }
            if (offset >= this.endOffset) {
                throw new BreakException();
            }
        }

        public void beginDocument() {
            this.scanCurrentOffset = this.startOffset;
            this.scanFontStateStack.addLast(MarkupTokenScanner.this.styleManager.createDefaultFontState());
        }

        public void endDocument() {
            this.updateOffset();
        }

        public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
            FontState fontState = type == DocumentBuilder.BlockType.CODE && attributes instanceof EmbeddingAttributes && ((EmbeddingAttributes)attributes).getForeignType() == "Html" ? MarkupTokenScanner.this.createHtmlFontState(this.scanFontStateStack.getLast(), (EmbeddingAttributes)attributes) : MarkupTokenScanner.this.createFontState(this.scanFontStateStack.getLast(), MarkupTokenScanner.this.getPrefCssStyles(type), attributes != null ? attributes.getCssStyle() : null);
            if (type == DocumentBuilder.BlockType.CODE && this.scanFontStateStack.size() > 1) {
                this.nestedCodeFontState = fontState;
                return;
            }
            this.updateOffset();
            this.scanFontStateStack.addLast(fontState);
        }

        public void endBlock() {
            if (this.nestedCodeFontState != null) {
                this.nestedCodeFontState = null;
                return;
            }
            this.updateOffset();
            this.scanFontStateStack.removeLast();
        }

        public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
            FontState fontState = type == DocumentBuilder.SpanType.CODE && attributes instanceof EmbeddingAttributes && ((EmbeddingAttributes)attributes).getForeignType() == "Html" ? MarkupTokenScanner.this.createHtmlFontState(this.scanFontStateStack.getLast(), (EmbeddingAttributes)attributes) : MarkupTokenScanner.this.createFontState(this.scanFontStateStack.getLast(), MarkupTokenScanner.this.getPrefCssStyles(type), attributes != null ? attributes.getCssStyle() : null);
            this.updateOffset();
            this.scanFontStateStack.addLast(fontState);
        }

        public void endSpan() {
            this.updateOffset();
            this.scanFontStateStack.removeLast();
        }

        public void beginHeading(int level, Attributes attributes) {
            FontState fontState = MarkupTokenScanner.this.createFontState(this.scanFontStateStack.getLast(), MarkupTokenScanner.this.getPrefCssStyles(level), attributes != null ? attributes.getCssStyle() : null);
            this.updateOffset();
            this.scanFontStateStack.addLast(fontState);
        }

        public void endHeading() {
            this.updateOffset();
            this.scanFontStateStack.removeLast();
        }

        public void characters(String text) {
            if (this.nestedCodeFontState != null) {
                this.updateOffset();
                this.scanFontStateStack.addLast(this.nestedCodeFontState);
                Locator locator = this.getLocator();
                this.updateOffset(locator.getLineDocumentOffset() + locator.getLineLength());
                this.scanFontStateStack.removeLast();
            }
        }

        public void charactersUnescaped(String literal) {
            this.characters(literal);
        }

        public void entityReference(String entity) {
            this.characters(entity);
        }

        public void image(Attributes attributes, String url) {
        }

        public void link(Attributes attributes, String hrefOrHashName, String text) {
        }

        public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        }

        public void acronym(String text, String definition) {
        }

        public void lineBreak() {
        }
    }

    private static class PositionToken
    extends Token {
        private final int offset;
        private final int length;

        public PositionToken(TextAttribute attribute, int offset, int length) {
            super((Object)attribute);
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return "Token [offset=" + this.offset + ", length=" + this.length + "]";
        }
    }
}

