/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.statet.jcommons.io.ByteOrderMark;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class TextContentDescriber
implements ITextContentDescriber {
    private static final @NonNull QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};

    public @NonNull QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, @Nullable IContentDescription description) throws IOException {
        return 1;
    }

    public int describe(InputStream contents, @Nullable IContentDescription description) throws IOException {
        if (description != null && description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            this.checkByteOrderMark(contents, description);
        }
        return 1;
    }

    protected @Nullable ByteOrderMark checkByteOrderMark(InputStream in, @Nullable IContentDescription description) throws IOException {
        ByteOrderMark bom = ByteOrderMark.read((InputStream)in);
        if (bom != null && description != null) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)(switch (bom) {
                case ByteOrderMark.UTF_8 -> IContentDescription.BOM_UTF_8;
                case ByteOrderMark.UTF_16BE -> IContentDescription.BOM_UTF_16BE;
                case ByteOrderMark.UTF_16LE -> IContentDescription.BOM_UTF_16LE;
                default -> throw new MatchException(null, null);
            }));
        }
        return bom;
    }
}

