/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractSettingsModelObject {
    private ReadWriteLock fLock;
    private final PropertyChangeSupport fBeanSupport = new PropertyChangeSupport(this);
    private boolean fIsDirty = false;

    protected AbstractSettingsModelObject() {
        this.fBeanSupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractSettingsModelObject.this.fIsDirty = true;
            }
        });
    }

    protected void installLock() {
        this.fLock = new ReentrantReadWriteLock(true);
    }

    public Lock getReadLock() {
        return this.fLock.readLock();
    }

    public Lock getWriteLock() {
        return this.fLock.writeLock();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fBeanSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.fBeanSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fBeanSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.fBeanSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.fBeanSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void resetDirty() {
        this.fIsDirty = false;
    }
}

