/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class PreferenceSetUIListener
implements PreferenceSetService.ChangeListener,
Listener {
    private final PreferenceAccess prefAccess;
    private final Control control;

    public static PreferenceSetUIListener subscribe(final PreferenceSetService.ChangeListener listener, PreferenceAccess prefAccess, ImSet<String> qualifiers, Control control) {
        PreferenceSetUIListener uiListener = new PreferenceSetUIListener(prefAccess, control){

            @Override
            protected void handlePreferenceChanged(PreferenceSetService.ChangeEvent event) {
                listener.onPreferenceChanged(event);
            }
        };
        uiListener.subscribe(qualifiers);
        return uiListener;
    }

    public PreferenceSetUIListener(PreferenceAccess prefAccess, Control control) {
        this.prefAccess = prefAccess;
        this.control = control;
        this.control.addListener(12, (Listener)this);
    }

    public void subscribe(ImSet<String> qualifiers) {
        this.prefAccess.addPreferenceSetListener((PreferenceSetService.ChangeListener)this, qualifiers);
    }

    public void unsubscribe() {
        this.prefAccess.removePreferenceSetListener((PreferenceSetService.ChangeListener)this);
    }

    public void handleEvent(Event event) {
        if (event.type == 12) {
            this.prefAccess.removePreferenceSetListener((PreferenceSetService.ChangeListener)this);
        }
    }

    public void onPreferenceChanged(final PreferenceSetService.ChangeEvent event) {
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (UIAccess.isOkToUse(PreferenceSetUIListener.this.control)) {
                    PreferenceSetUIListener.this.handlePreferenceChanged(event);
                }
            }
        });
    }

    protected abstract void handlePreferenceChanged(PreferenceSetService.ChangeEvent var1);
}

