/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.content;

import org.eclipse.statet.ecommons.ui.content.IElementFilter;
import org.eclipse.statet.ecommons.ui.content.ITextElementFilter;

public abstract class MultiTextElementFilter
implements ITextElementFilter {
    private final ITextElementFilter[] filters;
    private volatile String text;
    private String currentText;
    private Filter currentFilter;

    public MultiTextElementFilter(ITextElementFilter[] filters) {
        this.filters = filters;
        this.text = "";
    }

    protected abstract int getIdx(Object var1);

    @Override
    public boolean setText(String text) {
        if (text == null) {
            text = "";
        }
        boolean changed = !this.text.equals(text);
        this.text = text;
        return changed;
    }

    @Override
    public IElementFilter.IFinalFilter getFinal(boolean newData) {
        String text = this.text;
        if (text.length() == 0) {
            this.currentFilter = null;
        } else if (this.currentFilter == null || newData && this.text != this.currentText || !text.equals(this.currentText)) {
            this.currentText = text;
            IElementFilter.IFinalFilter[] finalFilters = new IElementFilter.IFinalFilter[this.filters.length];
            int i = 0;
            while (i < this.filters.length) {
                this.filters[i].setText(text);
                finalFilters[i] = this.filters[i].getFinal(newData);
                ++i;
            }
            this.currentFilter = new Filter(finalFilters);
        }
        return this.currentFilter;
    }

    private class Filter
    implements IElementFilter.IFinalFilter {
        private final IElementFilter.IFinalFilter[] finalFilters;

        Filter(IElementFilter.IFinalFilter[] filters) {
            this.finalFilters = filters;
        }

        private MultiTextElementFilter getSource() {
            return MultiTextElementFilter.this;
        }

        @Override
        public boolean select(Object element) {
            IElementFilter.IFinalFilter filter = this.finalFilters[MultiTextElementFilter.this.getIdx(element)];
            return filter.select(element);
        }

        @Override
        public boolean isSubOf(IElementFilter.IFinalFilter other) {
            return other == null || other instanceof Filter && this.isSubOf((Filter)other);
        }

        private boolean isSubOf(Filter other) {
            if (this.getSource() != other.getSource()) {
                return false;
            }
            int i = 0;
            while (i < this.finalFilters.length) {
                if (!this.finalFilters[i].isSubOf(other.finalFilters[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public boolean isEqualTo(IElementFilter.IFinalFilter other) {
            return this == other || other instanceof Filter && this.isEqualTo((Filter)other);
        }

        private boolean isEqualTo(Filter other) {
            if (this.getSource() != other.getSource()) {
                return false;
            }
            int i = 0;
            while (i < this.finalFilters.length) {
                if (!this.finalFilters[i].isEqualTo(other.finalFilters[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

