/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.content;

import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.content.TableFilterController;
import org.eclipse.statet.ecommons.ui.content.TextElementFilter;

public class SearchTextBinding
implements SearchText.Listener {
    protected final SearchText fTextControl;
    protected final TableFilterController fController;
    protected final TextElementFilter fFilter;

    public SearchTextBinding(SearchText text, TableFilterController controller, TextElementFilter filter) {
        this.fTextControl = text;
        this.fController = controller;
        this.fFilter = filter;
        this.fTextControl.addListener(this);
    }

    @Override
    public void textChanged(boolean user) {
        String text = this.getFilterString();
        if (this.fFilter.setText(text)) {
            this.fController.refresh(user);
        }
    }

    @Override
    public void downPressed() {
        this.okPressed();
        this.fController.refresh(true);
    }

    @Override
    public void okPressed() {
        String text = this.getFilterString();
        this.fFilter.setText(text);
        this.fController.refresh(true);
    }

    protected String getFilterString() {
        return this.fTextControl != null ? this.fTextControl.getText() : null;
    }
}

