/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public final class ImageUtils {
    public static int scaleLength(int length, int zoom) {
        if (zoom == 100) {
            return length;
        }
        return Math.round((float)(length * zoom) / 100.0f);
    }

    public static ImageData newDefaultImageData(int width, int height) {
        return new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
    }

    public static ImageData newDefaultImageData(int width, int height, int zoom) {
        return ImageUtils.newDefaultImageData(ImageUtils.scaleLength(width, zoom), ImageUtils.scaleLength(height, zoom));
    }

    public static ImageData newDefaultTransparentImageData(int width, int height) {
        ImageData imageData = ImageUtils.newDefaultImageData(width, height);
        imageData.setAlpha(0, 0, 0);
        return imageData;
    }

    public static ImageData newDefaultTransparentImageData(int width, int height, int zoom) {
        ImageData imageData = ImageUtils.newDefaultImageData(ImageUtils.scaleLength(width, zoom), ImageUtils.scaleLength(height, zoom));
        imageData.setAlpha(0, 0, 0);
        return imageData;
    }

    public static ImageData newDefaultTransparentImageData(Point size, int zoom) {
        ImageData imageData = ImageUtils.newDefaultImageData(ImageUtils.scaleLength(size.x, zoom), ImageUtils.scaleLength(size.y, zoom));
        imageData.setAlpha(0, 0, 0);
        return imageData;
    }

    private ImageUtils() {
    }
}

