/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt.util;

import org.eclipse.statet.ecommons.ui.swt.util.ColorUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

@NonNullByDefault
public class CssUtils {
    private static final byte ROOT = 1;
    private static final byte RULESET = 2;

    public static final void appendCssFontFamily(StringBuilder sb, @Nullable FontData fontData, String fallback) {
        if (fontData != null) {
            sb.append('\'');
            sb.append(fontData.getName());
            sb.append("', ");
        }
        sb.append(fallback);
    }

    public static final void appendCssFontWeight(StringBuilder sb, @Nullable FontData fontData) {
        if (fontData != null && (fontData.getStyle() & 1) != 0) {
            sb.append("bold");
        } else {
            sb.append("normal");
        }
    }

    public static final void appendCssFontStyle(StringBuilder sb, @Nullable FontData fontData) {
        if (fontData != null && (fontData.getStyle() & 2) != 0) {
            sb.append("italic");
        } else {
            sb.append("normal");
        }
    }

    public static final void appendCssFontSize(StringBuilder sb, @Nullable FontData fontData, int fallback) {
        if (fontData != null) {
            sb.append(fontData.getHeight());
        } else {
            sb.append(fallback);
        }
        sb.append("pt");
    }

    public static void appendCssColor(StringBuilder sb, RGB color) {
        sb.append('#');
        sb.append(ColorUtils.toColorDef(color).getRGBHexString());
    }

    private CssUtils() {
    }

    public static class StylesheetBuilder {
        private final StringBuilder sb = new StringBuilder();
        private final RulesetBuilder rulesetBuilder = new RulesetBuilder();
        private byte state = 1;

        private void setRoot() {
            switch (this.state) {
                case 2: {
                    this.sb.append("}\n");
                    this.state = 1;
                    return;
                }
                case 1: {
                    return;
                }
            }
            throw new IllegalStateException();
        }

        public StylesheetBuilder append(String s) {
            this.setRoot();
            this.sb.append(s);
            return this;
        }

        public RulesetBuilder addRuleset(String selectors) {
            this.setRoot();
            this.sb.append(selectors);
            this.sb.append(" { ");
            this.state = (byte)2;
            return this.rulesetBuilder;
        }

        public String build() {
            this.setRoot();
            return this.sb.toString();
        }

        public String toString() {
            return this.sb.toString();
        }

        public class RulesetBuilder {
            RulesetBuilder() {
            }

            public RulesetBuilder add(String property, String value) {
                StylesheetBuilder.this.sb.append(property);
                StylesheetBuilder.this.sb.append(": ");
                StylesheetBuilder.this.sb.append(value);
                StylesheetBuilder.this.sb.append("; ");
                return this;
            }

            public RulesetBuilder append(String s) {
                StylesheetBuilder.this.sb.append(s);
                return this;
            }

            public RulesetBuilder addMargin(int marginTop, int marginRight, int marginBottom, int marginLeft) {
                StylesheetBuilder.this.sb.append("margin: ");
                StylesheetBuilder.this.sb.append(marginTop);
                StylesheetBuilder.this.sb.append("px ");
                StylesheetBuilder.this.sb.append(marginRight);
                StylesheetBuilder.this.sb.append("px ");
                StylesheetBuilder.this.sb.append(marginBottom);
                StylesheetBuilder.this.sb.append("px ");
                StylesheetBuilder.this.sb.append(marginLeft);
                StylesheetBuilder.this.sb.append("px; ");
                return this;
            }

            public RulesetBuilder addMargin(int marginVertical, int marginHorizontal) {
                StylesheetBuilder.this.sb.append("margin: ");
                StylesheetBuilder.this.sb.append(marginVertical);
                StylesheetBuilder.this.sb.append("px ");
                StylesheetBuilder.this.sb.append(marginHorizontal);
                StylesheetBuilder.this.sb.append("px; ");
                return this;
            }

            public RulesetBuilder addMargin(int margin) {
                StylesheetBuilder.this.sb.append("margin: ");
                StylesheetBuilder.this.sb.append(margin);
                StylesheetBuilder.this.sb.append("px; ");
                return this;
            }

            public RulesetBuilder addFontFamily(@Nullable FontData fontData, String fallback) {
                StylesheetBuilder.this.sb.append("font-family: ");
                CssUtils.appendCssFontFamily(StylesheetBuilder.this.sb, fontData, fallback);
                StylesheetBuilder.this.sb.append("; ");
                return this;
            }

            public RulesetBuilder addFontWeight(@Nullable FontData fontData) {
                StylesheetBuilder.this.sb.append("font-weight: ");
                CssUtils.appendCssFontWeight(StylesheetBuilder.this.sb, fontData);
                StylesheetBuilder.this.sb.append("; ");
                return this;
            }

            public RulesetBuilder addFontStyle(@Nullable FontData fontData) {
                StylesheetBuilder.this.sb.append("font-style: ");
                CssUtils.appendCssFontStyle(StylesheetBuilder.this.sb, fontData);
                StylesheetBuilder.this.sb.append("; ");
                return this;
            }

            public RulesetBuilder addFontSize(@Nullable FontData fontData, int fallback) {
                StylesheetBuilder.this.sb.append("font-size: ");
                CssUtils.appendCssFontSize(StylesheetBuilder.this.sb, fontData, fallback);
                StylesheetBuilder.this.sb.append("; ");
                return this;
            }

            public RulesetBuilder addFontSize(String value) {
                this.add("font-size", value);
                return this;
            }

            public RulesetBuilder addBackground(RGB value) {
                StylesheetBuilder.this.sb.append("background: ");
                CssUtils.appendCssColor(StylesheetBuilder.this.sb, value);
                StylesheetBuilder.this.sb.append("; ");
                return this;
            }

            public RulesetBuilder addColor(RGB value) {
                StylesheetBuilder.this.sb.append("color: ");
                CssUtils.appendCssColor(StylesheetBuilder.this.sb, value);
                StylesheetBuilder.this.sb.append("; ");
                return this;
            }

            public StylesheetBuilder close() {
                StylesheetBuilder.this.setRoot();
                return StylesheetBuilder.this;
            }
        }
    }
}

