/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class TransformLayerDim<TLayer extends Layer>
extends ForwardLayerDim<TLayer> {
    public TransformLayerDim(TLayer layer, LayerDim underlyingDim) {
        super(layer, underlyingDim.getOrientation(), underlyingDim);
    }

    public TransformLayerDim(TLayer layer, Orientation orientation, LayerDim underlyingDim) {
        super(layer, orientation, underlyingDim);
    }

    @Override
    public long getPositionId(long refPosition, long position) {
        long underlyingRefPosition = this.localToUnderlyingPosition(refPosition, refPosition);
        return this.underlyingDim.getPositionId(underlyingRefPosition, refPosition == position ? underlyingRefPosition : this.localToUnderlyingPosition(refPosition, position));
    }

    @Override
    public long getPositionById(long id) {
        long underlyingPosition = this.underlyingDim.getPositionById(id);
        if (underlyingPosition == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        long position = this.doUnderlyingToLocalPosition(underlyingPosition);
        if (position < 0L || position >= this.getPositionCount()) {
            return Long.MIN_VALUE;
        }
        return position;
    }

    @Override
    public abstract long localToUnderlyingPosition(long var1, long var3);

    @Override
    public long underlyingToLocalPosition(LayerDim sourceUnderlyingDim, long underlyingPosition) {
        if (sourceUnderlyingDim != this.underlyingDim) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        return this.doUnderlyingToLocalPosition(underlyingPosition);
    }

    @Override
    public List<LRange> underlyingToLocalPositions(LayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositions) {
        if (sourceUnderlyingDim != this.underlyingDim) {
            throw new IllegalArgumentException("underlyingLayer");
        }
        ArrayList<LRange> localPositions = new ArrayList<LRange>(underlyingPositions.size());
        for (LRange underlyingPositionRange : underlyingPositions) {
            long last;
            if (underlyingPositionRange.start == underlyingPositionRange.end) {
                long position = this.doUnderlyingToLocalPosition(underlyingPositionRange.start);
                localPositions.add(new LRange(position, position));
                continue;
            }
            long first = this.doUnderlyingToLocalPosition(underlyingPositionRange.start);
            if (first > (last = this.doUnderlyingToLocalPosition(underlyingPositionRange.end - 1L))) continue;
            localPositions.add(new LRange(first, last + 1L));
        }
        return localPositions;
    }

    protected abstract long doUnderlyingToLocalPosition(long var1);

    @Override
    public long getPositionByPixel(long pixel) {
        long position = this.doUnderlyingToLocalPosition(this.underlyingDim.getPositionByPixel(pixel));
        if (position < 0L || position >= this.getPositionCount()) {
            throw new PixelOutOfBoundsException(pixel, this.getOrientation());
        }
        return position;
    }

    @Override
    public long getPositionStart(long refPosition, long position) {
        long underlyingRefPosition = this.localToUnderlyingPosition(refPosition, refPosition);
        return this.underlyingDim.getPositionStart(underlyingRefPosition, refPosition == position ? underlyingRefPosition : this.localToUnderlyingPosition(refPosition, position));
    }

    @Override
    public long getPositionStart(long position) {
        return this.underlyingDim.getPositionStart(this.localToUnderlyingPosition(position, position));
    }

    @Override
    public int getPositionSize(long refPosition, long position) {
        long underlyingRefPosition = this.localToUnderlyingPosition(refPosition, refPosition);
        return this.underlyingDim.getPositionSize(underlyingRefPosition, refPosition == position ? underlyingRefPosition : this.localToUnderlyingPosition(refPosition, position));
    }

    @Override
    public int getPositionSize(long position) {
        return this.underlyingDim.getPositionSize(this.localToUnderlyingPosition(position, position));
    }

    @Override
    public boolean isPositionResizable(long position) {
        long underlyingPosition = this.localToUnderlyingPosition(position, position);
        return this.underlyingDim.isPositionResizable(underlyingPosition);
    }
}

