/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.edit.CheckBoxStateEnum;
import org.eclipse.statet.ecommons.waltable.painter.cell.ImagePainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public abstract class TreeCheckBoxPainter
extends ImagePainter {
    private final Image checkedImg;
    private final Image semicheckedImg;
    private final Image uncheckedImg;

    public TreeCheckBoxPainter() {
        this(GUIHelper.getImage("checked"), GUIHelper.getImage("semichecked"), GUIHelper.getImage("unchecked"));
    }

    public TreeCheckBoxPainter(Image checkedImg, Image semicheckedImage, Image uncheckedImg) {
        this.checkedImg = checkedImg;
        this.semicheckedImg = semicheckedImage;
        this.uncheckedImg = uncheckedImg;
    }

    public long getPreferredWidth(boolean checked) {
        return checked ? this.checkedImg.getBounds().width : this.uncheckedImg.getBounds().width;
    }

    public long getPreferredHeight(boolean checked) {
        return checked ? this.checkedImg.getBounds().height : this.uncheckedImg.getBounds().height;
    }

    @Override
    protected Image getImage(LayerCell cell, ConfigRegistry configRegistry) {
        switch (this.getCheckBoxState(cell)) {
            case CHECKED: {
                return this.checkedImg;
            }
            case SEMICHECKED: {
                return this.semicheckedImg;
            }
        }
        return this.uncheckedImg;
    }

    protected abstract CheckBoxStateEnum getCheckBoxState(LayerCell var1);
}

