/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.workbench.search.ui;

import java.util.Comparator;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.collections.CategoryElementComparator;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ElementMatchComparator<E, M extends Match>
extends CategoryElementComparator<E, M> {
    private final @NonNull E[] elements0;
    private final @Nullable Comparator<? super E> elementComparator;
    private final @NonNull M[] matches0;
    private final @Nullable Comparator<? super M> matchComparator;

    public ElementMatchComparator(@NonNull E[] elements0, Comparator<? super E> elementComparator, @NonNull M[] matches0, Comparator<? super M> matchComparator) {
        if (elements0 == null) {
            throw new NullPointerException("elements0");
        }
        if (elementComparator == null && !Comparable.class.isAssignableFrom(elements0.getClass().getComponentType())) {
            throw new NullPointerException("elementComparator");
        }
        if (matches0 == null) {
            throw new NullPointerException("matches0");
        }
        if (matchComparator == null && !Comparable.class.isAssignableFrom(matches0.getClass().getComponentType())) {
            throw new NullPointerException("matchComparator");
        }
        this.elements0 = elements0;
        this.elementComparator = elementComparator;
        this.matches0 = matches0;
        this.matchComparator = matchComparator;
    }

    public @NonNull E[] getElement0() {
        return this.elements0;
    }

    public @Nullable Comparator<? super E> getElementComparator() {
        return this.elementComparator;
    }

    public @NonNull M[] getMatch0() {
        return this.matches0;
    }

    public @Nullable Comparator<? super M> getMatchComparator() {
        return this.matchComparator;
    }

    public E getCategory(M element) {
        return (E)element.getElement();
    }

    public int compareElement(M element1, M element2) {
        Comparator<M> comparator = this.matchComparator;
        return comparator != null ? comparator.compare(element1, element2) : ((Comparable)element1).compareTo(element2);
    }

    public int compareCategory(E category1, E category2) {
        Comparator<E> comparator = this.elementComparator;
        return comparator != null ? comparator.compare(category1, category2) : ((Comparable)category1).compareTo(category2);
    }
}

