/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.ui.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.model.core.element.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class FileBufferWorkingBuffer
extends org.eclipse.statet.ltk.model.core.impl.FileBufferWorkingBuffer {
    public static void syncExec(final SourceDocumentRunnable runnable) throws InvocationTargetException {
        final AtomicReference error = new AtomicReference();
        UIAccess.getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object docLock = null;
                AbstractDocument document = runnable.getDocument();
                if (document instanceof ISynchronizable) {
                    docLock = ((ISynchronizable)document).getLockObject();
                }
                if (docLock == null) {
                    docLock = new Object();
                }
                DocumentRewriteSession rewriteSession = null;
                try {
                    if (runnable.getRewriteSessionType() != null) {
                        rewriteSession = document.startRewriteSession(runnable.getRewriteSessionType());
                    }
                    Object object = docLock;
                    synchronized (object) {
                        if (runnable.getStampAssertion() > 0L && document.getModificationStamp() != runnable.getStampAssertion()) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "Document out of sync (usuallly caused by concurrent document modifications)."));
                        }
                        runnable.run();
                    }
                }
                catch (InvocationTargetException e) {
                    error.set(e);
                    if (rewriteSession == null) return;
                    document.stopRewriteSession(rewriteSession);
                    return;
                }
                catch (Exception e) {
                    try {
                        error.set(new InvocationTargetException(e));
                        if (rewriteSession == null) return;
                    }
                    catch (Throwable throwable) {
                        if (rewriteSession == null) throw throwable;
                        document.stopRewriteSession(rewriteSession);
                        throw throwable;
                    }
                    document.stopRewriteSession(rewriteSession);
                    return;
                }
                if (rewriteSession == null) return;
                document.stopRewriteSession(rewriteSession);
            }
        });
        if (error.get() != null) {
            throw (InvocationTargetException)error.get();
        }
    }

    public FileBufferWorkingBuffer(SourceUnit unit) {
        super(unit);
    }
}

