/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiEditorInput;

@NonNullByDefault
public class EditorUtils {
    public static List<IEditorPart> getDirtyEditors(boolean skipNonResourceEditors) {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (inputs.add(input) && (!skipNonResourceEditors || EditorUtils.isResourceEditorInput(input))) {
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private static boolean isResourceEditorInput(IEditorInput input) {
        if (input instanceof MultiEditorInput) {
            IEditorInput[] inputs = ((MultiEditorInput)input).getInput();
            int i = 0;
            while (i < inputs.length) {
                if (inputs[i].getAdapter(IResource.class) != null) {
                    return true;
                }
                ++i;
            }
        } else if (input.getAdapter(IResource.class) != null) {
            return true;
        }
        return false;
    }

    public static boolean isModelTypeEditorInput(IEditorInput input, String modelTypeId) {
        Object ifile = input.getAdapter(IFile.class);
        SourceUnitManager suManager = LtkModels.getSourceUnitManager();
        if (ifile != null) {
            SourceUnit su = suManager.getOpenSourceUnit(modelTypeId, Ltk.PERSISTENCE_CONTEXT, ifile);
            return su != null;
        }
        if (input instanceof IURIEditorInput) {
            IFileStore store;
            try {
                store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
            }
            catch (CoreException e) {
                return false;
            }
            SourceUnit su = suManager.getOpenSourceUnit(modelTypeId, Ltk.EDITOR_CONTEXT, (Object)store);
            return su != null;
        }
        return false;
    }

    public static IRegion getTextBlockFromSelection(IDocument document, int offset, int length) throws BadLocationException {
        int endOffset = offset + length;
        int firstLine = document.getLineOfOffset(offset);
        int lastLine = document.getLineOfOffset(endOffset);
        offset = document.getLineOffset(firstLine);
        int lastLineOffset = document.getLineOffset(lastLine);
        if (firstLine != lastLine && lastLineOffset == endOffset) {
            lastLineOffset = document.getLineOffset(--lastLine);
        }
        return new Region(offset, lastLineOffset + document.getLineLength(lastLine) - offset);
    }

    private EditorUtils() {
    }
}

