/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.nostart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.statet.ecommons.io.TextContentDescriber;
import org.eclipse.statet.jcommons.io.ByteOrderMark;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class RdTextContentDescriber
extends TextContentDescriber {
    private static final @NonNull QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String ENCODING_COMMAND_NAME = "encoding";
    private static final Pattern BRACKET_CONTENT_PATTERN = Pattern.compile("\\s*\\{\\s*(\\S*)\\s*\\}.*");

    public @NonNull QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, @Nullable IContentDescription description) throws IOException {
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            BufferedReader reader = new BufferedReader(contents);
            String encoding = this.parse(reader);
            if (encoding == null) {
                return 1;
            }
            description.setProperty(IContentDescription.CHARSET, (Object)encoding);
        }
        return 2;
    }

    public int describe(InputStream contents, @Nullable IContentDescription description) throws IOException {
        ByteOrderMark bom = this.checkByteOrderMark(contents, description);
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            contents.reset();
            BufferedReader reader = new BufferedReader(IOUtils.newStreamContentReader((InputStream)contents, (ByteOrderMark)bom, (Charset)StandardCharsets.ISO_8859_1));
            String encoding = this.parse(reader);
            if (encoding != null) {
                description.setProperty(IContentDescription.CHARSET, (Object)encoding);
            }
        }
        return 2;
    }

    private @Nullable String parse(BufferedReader reader) throws IOException {
        String line;
        block5: while ((line = reader.readLine()) != null) {
            int idx = 0;
            while (idx < line.length()) {
                switch (line.charAt(idx)) {
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '%': {
                        continue block5;
                    }
                    case '\\': {
                        Matcher matcher;
                        if (!line.regionMatches(idx + 1, ENCODING_COMMAND_NAME, 0, ENCODING_COMMAND_NAME.length()) || !(matcher = BRACKET_CONTENT_PATTERN.matcher(line.substring(idx + 1 + ENCODING_COMMAND_NAME.length()))).matches()) break block5;
                        return matcher.group(1);
                    }
                    default: {
                        break block5;
                    }
                }
                ++idx;
            }
        }
        return null;
    }
}

