/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.List;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.rmodel.RSourceFileElement;
import org.eclipse.statet.internal.r.core.rmodel.RSourceModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.rlang.RLangSrcStrElement;
import org.eclipse.statet.r.core.source.ast.RAstNode;

@NonNullByDefault
final class RSourceUnitElement
extends RSourceFileElement
implements BuildSourceFrameElement {
    private final RAstNode sourceNode;
    private List<? extends RLangSrcStrElement> sourceChildrenProtected = RSourceModel.NO_R_SOURCE_STRUCT_CHILDREN;

    public RSourceUnitElement(RSourceUnit sourceUnit, SourceModelStamp stamp, BuildSourceFrame envir, RAstNode node) {
        super(sourceUnit, stamp, envir);
        this.sourceNode = node;
    }

    @Override
    public void setSourceChildren(List<? extends RLangSrcStrElement> children) {
        this.sourceChildrenProtected = children;
    }

    @Override
    public BuildSourceFrame getBuildFrame() {
        return this.envir;
    }

    @Override
    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSrcStrElement> filter) {
        return LtkModelUtils.hasChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public List<? extends RLangSrcStrElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSrcStrElement> filter) {
        return LtkModelUtils.getChildren(this.sourceChildrenProtected, filter);
    }

    public TextRegion getSourceRange() {
        return this.sourceNode;
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.sourceNode);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RSourceUnitElement");
        RElementName elementName = this.getElementName();
        if (elementName != null) {
            sb.append(' ').append(elementName);
        } else {
            sb.append(" <unnamed>");
        }
        return sb.toString();
    }
}

