/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.io.DataStream;
import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class RFunctionSpec
implements Immutable {
    public static final int UNKNOWN = 0;
    private static final int OBJ_SHIFT = 0;
    private static final int NAME_SHIFT = 8;
    private static final int OTHER_SHIFT = 16;
    private static final int FLAGS_SHIFT = 24;
    public static final int UNSPECIFIC_OBJ = 1;
    public static final int FUN_OBJ = 4;
    public static final int CLASS_OBJ = 8;
    public static final int METHOD_OBJ = 16;
    public static final int OTHER_SPECIFIC_OBJ = 64;
    public static final int UNSPECIFIC_NAME = 256;
    public static final int PACKAGE_NAME = 512;
    public static final int CLASS_NAME = 2048;
    public static final int METHOD_NAME = 4096;
    public static final int FILE_NAME = 131072;
    public static final int HELP_TOPIC_NAME = 262144;
    public static final int RELATOR_CODE = 0x100000;
    public static final int MASK_AS = 0xF000000;
    public static final int AS_SYMBOL = 0x1000000;
    public static final int AS_STRING = 0x2000000;
    public static final int AS_N_VECTOR = 0x4000000;
    protected final @NonNull Parameter[] parameters;
    protected final ImList<? extends ReturnValue> returns;
    static final byte SER_V1 = 1;

    private static void test(int type) {
        switch (type) {
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 64: {
                break;
            }
            case 256: 
            case 512: 
            case 2048: 
            case 4096: {
                break;
            }
            case 131072: 
            case 262144: {
                break;
            }
            case 0x100000: {
                break;
            }
        }
    }

    public RFunctionSpec(String ... names) {
        this.parameters = new Parameter[names.length];
        int i = 0;
        while (i < names.length) {
            this.parameters[i] = new Parameter(i, names[i], 0, null);
            ++i;
        }
        this.returns = ImCollections.emptyList();
    }

    RFunctionSpec(@NonNull Parameter[] parameters, ImList<? extends ReturnValue> returns) {
        this.parameters = parameters;
        this.returns = returns;
    }

    public int getParamCount() {
        return this.parameters.length;
    }

    public boolean containsParam(@Nullable String name) {
        if (name != null) {
            int i = 0;
            while (i < this.parameters.length) {
                Parameter parameter = this.parameters[i];
                if (parameter.name != null && parameter.name.equals(name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public @Nullable Parameter getParam(@Nullable String name) {
        if (name != null) {
            int i = 0;
            while (i < this.parameters.length) {
                Parameter parameter = this.parameters[i];
                if (parameter.name != null && parameter.name.equals(name)) {
                    return parameter;
                }
                ++i;
            }
        }
        return null;
    }

    public Parameter getParam(int index) {
        return this.parameters[index];
    }

    public int indexOfParam(@Nullable String name) {
        if (name != null) {
            int i = 0;
            while (i < this.parameters.length) {
                Parameter parameter = this.parameters[i];
                if (parameter.name != null && parameter.name.equals(name)) {
                    return parameter.index;
                }
                ++i;
            }
        }
        return -1;
    }

    public ImList<? extends ReturnValue> getReturns() {
        return this.returns;
    }

    public RFunctionSpec(DataStream in, byte v) throws IOException {
        switch (v) {
            case 1: {
                int l = in.readInt();
                this.parameters = new Parameter[l];
                int i = 0;
                while (i < l) {
                    this.parameters[i] = new Parameter(i, in);
                    ++i;
                }
                l = in.readInt();
                switch (l) {
                    case 0: {
                        this.returns = ImCollections.emptyList();
                        break;
                    }
                    case 1: {
                        this.returns = ImCollections.newList((Object)new ReturnValue(in));
                        break;
                    }
                    default: {
                        Object[] array = new ReturnValue[l];
                        int i2 = 0;
                        while (i2 < l) {
                            array[i2] = new ReturnValue(in);
                            ++i2;
                        }
                        this.returns = ImCollections.newList((Object[])array);
                    }
                }
                return;
            }
        }
        throw new IOException("Format not supported: v= " + v);
    }

    public void writeTo(DataStream out, byte v) throws IOException {
        int l = this.parameters.length;
        out.writeInt(l);
        int i = 0;
        while (i < l) {
            this.parameters[i].writeTo(out);
            ++i;
        }
        out.writeInt(this.returns.size());
        for (ReturnValue r : this.returns) {
            r.writeTo(out);
        }
    }

    public int hashCode() {
        return this.parameters.hashCode() * 31 + this.returns.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RFunctionSpec) {
            RFunctionSpec other = (RFunctionSpec)obj;
            if (Arrays.equals(this.parameters, other.parameters) && this.returns.equals(other.returns)) {
                return true;
            }
        }
        return false;
    }

    public static final class Parameter
    implements TypeDescription {
        public final int index;
        private final @Nullable String name;
        private final int type;
        private final @Nullable String className;

        public Parameter(int index, @Nullable String name, int type, @Nullable String className) {
            this.index = index;
            this.name = name;
            this.type = type;
            this.className = className;
        }

        Parameter(int index, DataStream in) throws IOException {
            this.index = index;
            this.name = in.readString();
            this.type = in.readInt();
            this.className = in.readString();
        }

        void writeTo(DataStream out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.type);
            out.writeString(this.className);
        }

        public @Nullable String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public @Nullable String getClassName() {
            return this.className;
        }

        public int hashCode() {
            return this.index * 31 + Objects.hashCode(this.name);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Parameter) {
                Parameter other = (Parameter)obj;
                if (this.index == other.index && Objects.equals(this.name, other.name) && this.type == other.type && Objects.equals(this.className, other.className)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static final class ReturnValue
    implements TypeDescription {
        private final int type;
        private final @Nullable String className;

        public ReturnValue(int type, @Nullable String className) {
            this.type = type;
            this.className = className;
        }

        ReturnValue(DataStream in) throws IOException {
            this.type = in.readInt();
            this.className = in.readString();
        }

        void writeTo(DataStream out) throws IOException {
            out.writeInt(this.type);
            out.writeString(this.className);
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public @Nullable String getClassName() {
            return this.className;
        }

        public int hashCode() {
            return this.type * 31 + Objects.hashCode(this.className);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ReturnValue) {
                ReturnValue other = (ReturnValue)obj;
                if (this.type == other.type && Objects.equals(this.className, other.className)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static interface TypeDescription
    extends Immutable {
        public int getType();

        public @Nullable String getClassName();
    }
}

