/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.r.core.pkgmanager.RPkgResolver;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.ui.REnvLabelProvider;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

@NonNullByDefault
abstract class SummaryPage
extends WizardPage {
    private final IRPkgManager.Ext pkgManager;
    private final RPkgResolver resolver;
    private ViewerUtils.TableComposite table = (ViewerUtils.TableComposite)ObjectUtils.nonNullLateInit();

    public SummaryPage(IRPkgManager.Ext pkgManager, RPkgResolver resolver, String title) {
        super("InstallPkgsSummaryPage");
        this.pkgManager = pkgManager;
        this.resolver = resolver;
        this.setTitle(title);
        this.setDescription("Summary packages to install/update.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newContentGrid((int)1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText("Packages to install:");
        this.table = new ViewerUtils.TableComposite(composite, 268503554);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn column = this.table.addColumn("Name", 16384, (ColumnLayoutData)new ColumnWeightData(60, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                RPkgAction action = (RPkgAction)cell.getElement();
                cell.setText(action.getPkg().getName());
            }
        });
        column = this.table.addColumn("", 16384, (ColumnLayoutData)new ColumnPixelData(LayoutUtils.hintColWidth((Table)this.table.table, (int)10), true, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                RPkgAction action = (RPkgAction)cell.getElement();
                cell.setText(SummaryPage.this.resolver.getReason(action.getPkg()));
            }
        });
        column = this.table.addColumn("Version", 16384, (ColumnLayoutData)new ColumnPixelData(LayoutUtils.hintColWidth((Table)this.table.table, (int)10), true, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                RPkgAction action = (RPkgAction)cell.getElement();
                cell.setText(action.getPkg().getVersion().toString());
            }
        });
        column = this.table.addColumn("From", 16384, (ColumnLayoutData)new ColumnWeightData(40, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                RRepo repo;
                RPkgAction action = (RPkgAction)cell.getElement();
                if (action instanceof RPkgAction.Install) {
                    RPkgAction.Install install = (RPkgAction.Install)action;
                    v0 = SummaryPage.this.pkgManager.getRepo(install.getRepoId());
                } else {
                    v0 = repo = null;
                }
                if (repo != null) {
                    RPkgType repoPkgType = repo.getPkgType();
                    if (repoPkgType != null) {
                        StringBuilder sb = new StringBuilder(repo.getName());
                        sb.append(" (");
                        sb.append(repoPkgType.getLabel());
                        sb.append(")");
                        cell.setText(sb.toString());
                    } else {
                        cell.setText(repo.getName());
                    }
                } else {
                    cell.setText("");
                }
            }
        });
        column = this.table.addColumn("To", 16384, (ColumnLayoutData)new ColumnWeightData(40, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                RPkgAction action = (RPkgAction)cell.getElement();
                cell.setText(REnvLabelProvider.getSafeLabel(action.getLibLocation()));
            }
        });
        this.table.table.setHeaderVisible(true);
        this.table.table.setLinesVisible(true);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateInput();
        }
    }

    public abstract void updateInput();

    protected void setActions(List<? extends RPkgAction> list) {
        this.table.viewer.setInput(list);
    }
}

