/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.ts.core.console;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.statet.rj.ts.core.console.AbstractRConsoleRunnable;
import org.eclipse.statet.rj.ts.core.console.RConsoleService;
import org.eclipse.statet.rj.ts.core.util.RToolServiceWrapper;

@NonNullByDefault
public class AbstractRConsoleOptRunnable
extends AbstractRConsoleRunnable {
    public AbstractRConsoleOptRunnable(String typeId, String label) {
        super(typeId, label);
    }

    @Override
    public boolean canRunIn(Tool tool) {
        return tool.isProvidingFeatureSet("org.eclipse.statet.rj.services.RService");
    }

    @Override
    protected void run(RToolService r, ProgressMonitor m) throws StatusException {
        if (r instanceof RConsoleService) {
            this.run((RConsoleService)r, m);
        } else {
            this.run(new ThisService(r), m);
        }
    }

    private static class ThisService
    extends RToolServiceWrapper
    implements RConsoleService {
        public ThisService(RToolService service) {
            super(service);
        }

        public boolean acceptNewConsoleCommand() {
            return true;
        }

        public void submitToConsole(String input, ProgressMonitor m) throws StatusException {
            this.service.evalVoid("{\n" + input + "\n}", m);
        }

        @Override
        public void briefAboutToChange() {
        }

        @Override
        public void briefChanged(int o) {
        }
    }
}

