/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rtm.ggplot.ui.editors;

import java.util.ArrayList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.databinding.CustomViewerObservables;
import org.eclipse.statet.ecommons.emf.ui.databinding.DetailContext;
import org.eclipse.statet.ecommons.emf.ui.forms.Detail;
import org.eclipse.statet.ecommons.emf.ui.forms.DetailStack;
import org.eclipse.statet.ecommons.emf.ui.forms.EFFormSection;
import org.eclipse.statet.ecommons.emf.ui.forms.EFToolkit;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.statet.ecommons.ui.components.WaCombo;
import org.eclipse.statet.ecommons.ui.components.WaComboViewer;
import org.eclipse.statet.internal.rtm.ggplot.ui.editors.FacetGridDetail;
import org.eclipse.statet.internal.rtm.ggplot.ui.editors.FacetWrapDetail;
import org.eclipse.statet.rtm.ggplot.GGPlotPackage;
import org.eclipse.statet.rtm.ggplot.core.RtGGPlotCorePlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FacetSection
extends EFFormSection {
    private WaCombo typeControl;
    private TableViewer typeViewer;
    private DetailStack detailStack;

    public FacetSection(IEFFormPage page, Composite parent) {
        super(page, parent, "Layout / Facets", null);
        this.createClient();
    }

    protected Layout createClientLayout() {
        GridLayout layout = (GridLayout)super.createClientLayout();
        layout.marginTop = 0;
        return layout;
    }

    protected void createContent(Composite composite) {
        IEFFormPage page = this.getPage();
        EFToolkit toolkit = page.getToolkit();
        this.typeControl = new WaCombo(composite, 2048);
        this.typeViewer = new WaComboViewer(this.typeControl);
        toolkit.adapt((Composite)this.typeControl);
        this.typeControl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(page.getEditor().getAdapterFactory()){

            public Image getColumnImage(Object object, int columnIndex) {
                if (object instanceof String && columnIndex == 0) {
                    return this.getImageFromObject(RtGGPlotCorePlugin.INSTANCE.getImage("full/obj16/NoFacetLayout"));
                }
                return super.getColumnImage(object, columnIndex);
            }
        });
        this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.detailStack = new Details(page, composite);
        this.detailStack.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
    }

    public void addBindings(IEMFEditContext context) {
        IObservableValue facetObservable = EMFEditProperties.value((EditingDomain)context.getEditingDomain(), (EStructuralFeature)GGPlotPackage.Literals.GG_PLOT__FACET).observeDetail(context.getBaseObservable());
        ArrayList<String> options = new ArrayList<String>();
        options.add("Single Plot / No Facets");
        options.add((String)GGPlotPackage.eINSTANCE.getGGPlotFactory().createWrapFacetLayout());
        options.add((String)GGPlotPackage.eINSTANCE.getGGPlotFactory().createGridFacetLayout());
        context.getDataBindingContext().bindValue((IObservableValue)CustomViewerObservables.observeComboSelection((AbstractTableViewer)this.typeViewer, options), facetObservable);
        DetailContext detailContext = new DetailContext(context, facetObservable);
        this.detailStack.setContext((IEMFEditContext)detailContext);
    }

    private static class Details
    extends DetailStack {
        public Details(IEFFormPage page, Composite parent) {
            super(page, parent);
        }

        protected Detail createDetail(EObject value) {
            if (value != null) {
                switch (value.eClass().getClassifierID()) {
                    case 16: {
                        return new FacetWrapDetail(this);
                    }
                    case 15: {
                        return new FacetGridDetail(this);
                    }
                }
            }
            return super.createDetail(value);
        }
    }
}

