/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.rmi;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;

@NonNullByDefault
public class RMIAddress {
    public static final Sec SSH = new Sec("ssh");
    public static final Sec SSL = new Sec("ssl");
    private static final int DEFAULT_PORT_NUM = 1099;
    public static final Port DEFAULT_PORT = new Port(1099);
    public static final String REGISTRY_NAME = "";
    private static final byte RESOLVE = 1;
    public static final byte PARSE_REGISTRY = 2;
    private final @Nullable String host;
    private @Nullable InetAddress hostInetAddress;
    private final Port port;
    private final @Nullable Sec sec;
    private final String path;
    private @Nullable String address;
    private volatile @Nullable String ser;

    public static void validate(String address) throws MalformedURLException {
        try {
            new RMIAddress(address, 0);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public static RMIAddress parse(String address, byte flags) throws MalformedURLException, UnknownHostException {
        return new RMIAddress(address, flags | 1);
    }

    public static RMIAddress parse(String address) throws MalformedURLException, UnknownHostException {
        return RMIAddress.parse(address, (byte)0);
    }

    public static RMIAddress parseUnresolved(String address, byte flags) throws MalformedURLException {
        try {
            return new RMIAddress(address, flags);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public static RMIAddress parseUnresolved(String address) throws MalformedURLException {
        return RMIAddress.parseUnresolved(address, (byte)0);
    }

    private static @Nullable String getHostString(@Nullable InetAddress hostInetAddress) {
        if (hostInetAddress == null) {
            return null;
        }
        String s = hostInetAddress.getHostAddress();
        if (hostInetAddress instanceof Inet6Address && s.charAt(0) != '[') {
            return "[" + s + "]";
        }
        return s;
    }

    private static @Nullable String checkHostString(@Nullable String host) {
        if (host != null) {
            if (host.isEmpty()) {
                return null;
            }
            if (host.charAt(0) != '[' && CommonsNet.isIpV6Address(host)) {
                return "[" + host + "]";
            }
        }
        return host;
    }

    private static InetAddress resolveHostInetAddress(@Nullable String host) throws UnknownHostException {
        return host == null || CommonsNet.isCommonLoopback(host) ? CommonsNet.getLocalLoopbackInetAddress() : InetAddress.getByName(host);
    }

    private static Port parsePortUrl(String port) throws MalformedURLException {
        try {
            return Port.valueOf(port);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Invalid port: " + e.getLocalizedMessage());
        }
    }

    private static Port checkPort(Port port) {
        return port.get() == 1099 ? DEFAULT_PORT : port;
    }

    private static boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == '/';
    }

    private static String checkNameUrl(String s) throws MalformedURLException {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!RMIAddress.isNameChar(c)) {
                throw new MalformedURLException("Invalid path component (RMI service name): character '" + c + "' is not allowed.");
            }
            ++i;
        }
        return s;
    }

    private static String checkNameArg(String s) throws IllegalArgumentException {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!RMIAddress.isNameChar(c)) {
                throw new IllegalArgumentException("Invalid name: character '" + c + "' is not allowed.");
            }
            ++i;
        }
        return s;
    }

    @Deprecated
    public RMIAddress(String address) throws UnknownHostException, MalformedURLException {
        this(address, 1);
    }

    public RMIAddress(@Nullable String host, int portNum, @Nullable String name) throws IllegalArgumentException, UnknownHostException {
        this(RMIAddress.checkHostString(host), RMIAddress.resolveHostInetAddress(host), portNum < 0 ? DEFAULT_PORT : RMIAddress.checkPort(new Port(portNum)), null, name == null ? REGISTRY_NAME : RMIAddress.checkNameArg(name));
    }

    public RMIAddress(@Nullable InetAddress address, Port port, @Nullable Sec sec, String name) {
        this(RMIAddress.getHostString(address), address == null ? CommonsNet.getLocalLoopbackInetAddress() : address, RMIAddress.checkPort(port), sec, RMIAddress.checkNameArg(name));
    }

    @Deprecated
    public RMIAddress(InetAddress address, Port port, boolean isSsl, String name) {
        this(RMIAddress.getHostString(address), address, RMIAddress.checkPort(port), isSsl ? SSL : null, RMIAddress.checkNameArg(name));
    }

    public RMIAddress(@Nullable InetAddress address, Port port, String name) {
        this(address, port, null, name);
    }

    public RMIAddress(RMIAddress registry, String name) {
        this(registry.host, registry.hostInetAddress, registry.port, registry.sec, RMIAddress.checkNameArg(name));
    }

    private RMIAddress(String address, int flags) throws UnknownHostException, MalformedURLException {
        int idxPort;
        int idxEndAuth;
        int idx;
        int l = address.length();
        if (address.startsWith("ssh:")) {
            idx = 4;
            this.sec = SSH;
        } else if (address.startsWith("ssl:")) {
            idx = 4;
            this.sec = SSL;
        } else {
            idx = 0;
            this.sec = null;
        }
        if (address.startsWith("rmi:", idx)) {
            idx += 4;
        }
        if (address.startsWith("//", idx)) {
            idx += 2;
        }
        if ((idxEndAuth = address.indexOf(47, idx)) == -1) {
            if ((flags & 2) == 0) {
                throw new MalformedURLException("Missing path component (RMI service name)");
            }
            idxEndAuth = l;
        }
        if (idx < idxEndAuth && address.charAt(idx) == '[') {
            int idxEnd = RMIAddress.indexOf(address, ']', idx + 1, idxEndAuth);
            if (idxEnd == -1 || !CommonsNet.isIpV6Address(this.host = address.substring(idx, idxEnd + 1))) {
                throw new MalformedURLException("Invalid authority: invalid IPv6 address");
            }
            idx = idxEnd + 1;
            if (idx < idxEndAuth) {
                if (address.charAt(idx) != ':') {
                    throw new MalformedURLException("Invalid authority");
                }
                idxPort = idx;
            } else {
                idxPort = -1;
            }
        } else {
            idxPort = RMIAddress.indexOf(address, ':', idx, idxEndAuth);
            int idxEnd = idxPort != -1 ? idxPort : idxEndAuth;
            this.host = idx < idxEnd ? address.substring(idx, idxEnd) : null;
        }
        this.port = idxPort != -1 ? RMIAddress.checkPort(RMIAddress.parsePortUrl(address.substring(idxPort + 1, idxEndAuth))) : DEFAULT_PORT;
        idx = idxEndAuth + 1;
        String string = this.path = idx >= l || (flags & 2) != 0 ? REGISTRY_NAME : RMIAddress.checkNameUrl(address.substring(idx, l));
        if ((flags & 1) != 0) {
            this.hostInetAddress = RMIAddress.resolveHostInetAddress(this.host);
        }
    }

    private RMIAddress(@Nullable String host, @Nullable InetAddress hostInetAddress, Port port, @Nullable Sec sec, String path) {
        this.host = host;
        this.hostInetAddress = hostInetAddress;
        this.port = port;
        this.sec = sec;
        this.path = path;
    }

    public boolean isResolved() {
        return this.hostInetAddress != null;
    }

    public RMIAddress resolve() throws UnknownHostException {
        if (this.hostInetAddress != null) {
            return this;
        }
        return new RMIAddress(this.host, RMIAddress.resolveHostInetAddress(this.host), this.port, this.sec, this.path);
    }

    public String getHost() {
        String host = this.host;
        return host == null ? CommonsNet.LOCAL_LOOPBACK_STRING : host;
    }

    public InetAddress getHostInetAddress() {
        InetAddress hostInetAddress = this.hostInetAddress;
        if (hostInetAddress == null) {
            throw new UnsupportedOperationException("address is unresolved");
        }
        return hostInetAddress;
    }

    public boolean isLocalHost() {
        String host = this.host;
        if (host == null) {
            return true;
        }
        InetAddress hostInetAddress = this.hostInetAddress;
        if (hostInetAddress != null && hostInetAddress.isLoopbackAddress()) {
            return true;
        }
        return CommonsNet.isLocalLocalhost(host);
    }

    public Port getPort() {
        return this.port;
    }

    public int getPortNum() {
        return this.port.get();
    }

    public @Nullable Sec getSec() {
        return this.sec;
    }

    public String getName() {
        return this.path;
    }

    public String getAddress() {
        String address = this.address;
        if (address == null) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("rmi://");
            if (this.host != null) {
                sb.append(this.host);
            }
            if (this.port != DEFAULT_PORT) {
                sb.append(':');
                sb.append(this.port);
            }
            sb.append('/');
            sb.append(this.path);
            this.address = address = sb.toString();
        }
        return address;
    }

    public RMIAddress getRegistryAddress() {
        return new RMIAddress(this.host, this.hostInetAddress, this.port, this.sec, REGISTRY_NAME);
    }

    public Remote lookup() throws RemoteException, NotBoundException, AccessException {
        RMIRegistry rmiRegistry = new RMIRegistry(this.getRegistryAddress(), false);
        return rmiRegistry.getRegistry().lookup(this.getName());
    }

    public boolean isSsl() {
        return this.sec == SSL;
    }

    public String toString() {
        Object ser = this.ser;
        if (ser == null) {
            ser = this.getAddress();
            Sec sec = this.sec;
            if (sec != null) {
                ser = sec.scheme + ":" + (String)ser;
            }
            this.ser = ser;
        }
        return ser;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof RMIAddress)) break block3;
                RMIAddress other = (RMIAddress)obj;
                if (Objects.equals(this.host, other.host) && this.port.equals(other.port) && this.sec == other.sec && this.path.equals(other.path) && Objects.equals(this.hostInetAddress, other.hostInetAddress)) break block2;
            }
            return false;
        }
        return true;
    }

    private static int indexOf(String s, char c, int fromIndex, int endIndex) {
        int idx = s.indexOf(c, fromIndex);
        return idx < endIndex ? idx : -1;
    }

    public static class Sec {
        private final String scheme;

        public Sec(String scheme) {
            this.scheme = scheme;
        }

        public String toString() {
            return this.scheme;
        }
    }
}

