/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class DecoratedElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int DEPRECATED = 16;
    public static final int IGNORE_OPTIONAL_PROBLEMS = 256;
    private final ImageDescriptor baseImage;
    private final int flags;
    private @Nullable Point size;

    public DecoratedElementImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.baseImage = (ImageDescriptor)ObjectUtils.nonNullAssert((Object)baseImage);
        this.flags = flags;
    }

    protected final ImageDescriptor getBaseImage() {
        return this.baseImage;
    }

    protected final int getFlags() {
        return this.flags;
    }

    protected final Point getSize() {
        Point size = this.size;
        if (size == null) {
            CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(this.getBaseImage());
            this.size = size = new Point(data.getWidth(), data.getHeight());
        }
        return size;
    }

    protected void drawCompositeImage(int width, int height) {
        if ((this.flags & 0x10) != 0) {
            Point size = this.getSize();
            CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(SharedUIResources.getInstance().getImageDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/deprecated"));
            this.drawImage((ImageDataProvider)data, 0, size.y - data.getHeight());
        }
        CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(this.getBaseImage());
        this.drawImage((ImageDataProvider)data, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(desc);
        int x = pos.x - data.getWidth();
        if (x >= 0) {
            this.drawImage((ImageDataProvider)data, x, pos.y);
            pos.x = x;
        }
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(desc);
        int x = pos.x - data.getWidth();
        int y = pos.y - data.getHeight();
        if (x >= 0 && y >= 0) {
            this.drawImage((ImageDataProvider)data, x, y);
            pos.x = x;
        }
    }

    private void addBottomLeftImage(ImageDescriptor desc, Point pos) {
        CompositeImageDescriptor.CachedImageDataProvider data = this.createCachedImageDataProvider(desc);
        int x = pos.x;
        int y = pos.y - data.getHeight();
        int xEnd = x + data.getWidth();
        if (xEnd < this.getSize().x && y >= 0) {
            this.drawImage((ImageDataProvider)data, x, y);
            pos.x = xEnd;
        }
    }

    private void drawTopRight() {
    }

    private void drawBottomRight() {
    }

    private void drawBottomLeft() {
        Point pos = new Point(0, this.getSize().y);
        if ((this.flags & 4) != 0) {
            this.addBottomLeftImage(SharedUIResources.getInstance().getImageDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/Error"), pos);
        } else if ((this.flags & 2) != 0) {
            this.addBottomLeftImage(SharedUIResources.getInstance().getImageDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/Warning"), pos);
        } else if ((this.flags & 1) != 0) {
            this.addBottomLeftImage(SharedUIResources.getInstance().getImageDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/Info"), pos);
        }
        if ((this.flags & 0x100) != 0) {
            this.addBottomLeftImage(SharedUIResources.getInstance().getImageDescriptor("org.eclipse.statet.ecommons.uimisc/images/ovr/ignore-OptionalProblems"), pos);
        }
    }

    public int hashCode() {
        return this.baseImage.hashCode() ^ this.flags;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && ((Object)((Object)this)).getClass() == obj.getClass()) {
            DecoratedElementImageDescriptor other = (DecoratedElementImageDescriptor)((Object)obj);
            return this.baseImage.equals(other.baseImage) && this.flags == other.flags;
        }
        return false;
    }
}

