/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.statet.internal.rhelp.core.REnvHelpIndex;
import org.eclipse.statet.internal.rhelp.core.SerUtil;
import org.eclipse.statet.internal.rhelp.core.http.HttpHeaderUtils;
import org.eclipse.statet.internal.rhelp.core.server.NotFoundException;
import org.eclipse.statet.internal.rhelp.core.server.ResponseException;
import org.eclipse.statet.internal.rhelp.core.server.ServerApi;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.io.DataStream;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchQuery;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;
import org.eclipse.statet.rhelp.core.RPkgHelp;

@NonNullByDefault
public abstract class ServerREnvHelpAccess
implements REnvHelpIndex {
    protected static final @NonNull String[] NO_PARAMS = new String[0];
    private final URI url;
    private final String basePath;
    private final String rEnvId;
    private final String path;
    private final SerUtil serUtil = new SerUtil();
    private final String dsModestAcceptHeader = "application/x.org.eclipse.statet.rhelp-ds";
    private final String dsVersionedAcceptHeader = ServerREnvHelpAccess.createDSAcceptHeader(this.serUtil);

    private static String createDSAcceptHeader(SerUtil serUtil) {
        HttpHeaderUtils.HeaderBuilder builder = new HttpHeaderUtils.HeaderBuilder();
        int prio = 10;
        int[] nArray = SerUtil.KNOWN_VERSIONS;
        int n = SerUtil.KNOWN_VERSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            int knownVersion = nArray[n2];
            if (serUtil.canRead(knownVersion, "server")) {
                builder.newEntry("application/x.org.eclipse.statet.rhelp-ds", (float)prio / 10.0f);
                builder.addParameter("ser", Integer.toString(knownVersion));
                --prio;
            }
            ++n2;
        }
        return builder.build();
    }

    public ServerREnvHelpAccess(URI uri) {
        this.url = uri;
        String uriPath = (String)ObjectUtils.nonNullAssert((Object)uri.getPath());
        int idStart = uriPath.lastIndexOf(47);
        this.basePath = uriPath.substring(0, idStart);
        this.rEnvId = uriPath.substring(idStart + 1);
        this.path = this.basePath + "/rhelp/api/v1/" + this.rEnvId + "/";
    }

    @Override
    public void dispose() {
    }

    protected final String getBasePath() {
        return this.basePath;
    }

    protected final String createPath(String s1) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length());
        sb.append(this.path);
        sb.append(s1);
        return sb.toString();
    }

    protected final String createPath(String s1, String s2) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length() + s2.length() + 1);
        sb.append(this.path);
        sb.append(s1);
        sb.append('/');
        sb.append(s2);
        return sb.toString();
    }

    protected final String createPath(String s1, String s2, String s3) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length() + s2.length() + s3.length() + 2);
        sb.append(this.path);
        sb.append(s1);
        sb.append('/');
        sb.append(s2);
        sb.append('/');
        sb.append(s3);
        return sb.toString();
    }

    protected final String createPath(String s1, String s2, String s3, String s4) {
        StringBuilder sb = new StringBuilder(this.path.length() + s1.length() + s2.length() + s3.length() + s4.length() + 3);
        sb.append(this.path);
        sb.append(s1);
        sb.append('/');
        sb.append(s2);
        sb.append('/');
        sb.append(s3);
        sb.append('/');
        sb.append(s4);
        return sb.toString();
    }

    protected URI createUrl(String path) {
        try {
            return new URI(this.url.getScheme(), null, this.url.getHost(), this.url.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected StatusException onCancelled() {
        return new StatusException(Status.CANCEL_STATUS);
    }

    protected StatusException onTimeout(@Nullable Throwable e) {
        return new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", 1001, "R help server access - Timeout.", e));
    }

    protected StatusException onConnectError(@Nullable Throwable e) {
        return new StatusException((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", 1002, "R help server access - Failed to connect to server.", e));
    }

    protected StatusException onFailed(@Nullable Throwable e) {
        ErrorStatus status = new ErrorStatus("org.eclipse.statet.rhelp.core", "R help server access - Failed to perform search.", e);
        CommonsRuntime.log((Status)status);
        return new StatusException((Status)status);
    }

    protected abstract @Nullable InputStream getDataStreamIn(URI var1, @Nullable String var2, String var3) throws StatusException, ResponseException;

    protected abstract InputStream getDataStreamIn(URI var1, @NonNull String[] var2, byte[] var3, String var4) throws StatusException, ResponseException;

    protected abstract byte[] getDataStreamBytes(URI var1, @NonNull String[] var2, String var3, int var4, @Nullable ProgressMonitor var5) throws StatusException, ResponseException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadREnvHelpData(REnvHelpConfiguration rEnvConfig, long currentStamp, SerUtil.Controller saveCheck) throws Exception {
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream in = this.getDataStreamIn(this.createUrl(this.createPath("basic-data")), ServerApi.createETag(currentStamp), this.dsVersionedAcceptHeader);){
            if (in != null) return this.serUtil.save(rEnvConfig, in, saveCheck);
            return false;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public <T> @Nullable T loadREnvHelpData(long currentStamp, Function<@Nullable InputStream, T> reader) throws Exception {
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream in = this.getDataStreamIn(this.createUrl(this.createPath("basic-data")), ServerApi.createETag(currentStamp), this.dsVersionedAcceptHeader);){
            return reader.apply(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public List<RHelpPage> getPagesForTopic(String topic, Map<String, RPkgHelp> packageMap, int timeout, @Nullable ProgressMonitor m) throws StatusException {
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (DataStream in = DataStream.get((InputStream)new ByteArrayInputStream(this.getDataStreamBytes(this.createUrl(this.createPath("pages")), new String[]{"topic", topic}, "application/x.org.eclipse.statet.rhelp-ds", timeout, m)));){
                int n = in.readInt();
                ArrayList<RHelpPage> pages = new ArrayList<RHelpPage>(n);
                int i = 0;
                while (i < n) {
                    RHelpPage page;
                    String pkgName = (String)ObjectUtils.nonNullAssert((Object)in.readString());
                    String pageName = (String)ObjectUtils.nonNullAssert((Object)in.readString());
                    RPkgHelp pkgHelp = packageMap.get(pkgName);
                    if (pkgHelp != null && (page = pkgHelp.getPage(pageName)) != null) {
                        pages.add(page);
                    }
                    ++i;
                }
                return pages;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (StatusException e) {
            throw e;
        }
        catch (Exception e) {
            return ImCollections.emptyList();
        }
    }

    @Override
    public @Nullable String getHtmlPage(RPkgHelp pkgHelp, String pageName, @Nullable String queryString, int timeout, @Nullable ProgressMonitor m) throws StatusException {
        try {
            Throwable throwable = null;
            Object var7_11 = null;
            try {
                String[] stringArray;
                URI uRI = this.createUrl(this.createPath("pkgs", pkgHelp.getName(), "pages", pageName));
                if (queryString != null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "qs";
                    stringArray = stringArray2;
                    stringArray2[1] = queryString;
                } else {
                    stringArray = NO_PARAMS;
                }
                try (DataStream in = DataStream.get((InputStream)new ByteArrayInputStream(this.getDataStreamBytes(uRI, stringArray, "application/x.org.eclipse.statet.rhelp-ds", timeout, m)));){
                    return in.readString();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (StatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.onFailed(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void search(RHelpSearchQuery searchQuery, List<RPkgHelp> packageList, Map<String, RPkgHelp> packageMap, RHelpSearchRequestor requestor) throws StatusException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 10[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

