/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.ee8.jetty;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.ee8.nested.ResourceService;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.statet.internal.rhelp.core.server.jetty.ExtMimeTypes;
import org.eclipse.statet.internal.rhelp.core.server.jetty.PathResourceHttpContentFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee8.ResourceHandler;

@NonNullByDefault
public class JettyResourceHandler
extends ResourceService
implements ResourceHandler {
    private final ExtMimeTypes mediaTypes;

    public JettyResourceHandler(MediaTypeProvider defaultTypes) {
        this.mediaTypes = new ExtMimeTypes(defaultTypes);
        PathResourceHttpContentFactory contentFactory = new PathResourceHttpContentFactory(this.mediaTypes);
        this.setHttpContentFactory(contentFactory);
        this.setDirAllowed(false);
    }

    @Override
    public void setSpecialMediaTypes(MediaTypeProvider types) {
        this.mediaTypes.setSpecialMediaTypes(types);
    }

    @Override
    public void setCacheControl(String value) {
        this.setCacheControl((HttpField)new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, value));
    }

    @Override
    public void doGet(Path path, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpContent content = ((PathResourceHttpContentFactory)this.getHttpContentFactory()).getContent(path, path.toString());
        boolean releaseContent = true;
        try {
            Resource resource;
            if (content == null || (resource = content.getResource()) == null || Resources.missing((Resource)resource)) {
                this.notFound(req, resp);
                return;
            }
            if (resource.isDirectory()) {
                resp.sendError(400);
            }
            if (!this.passConditionalHeaders(req, resp, content)) {
                return;
            }
            Enumeration reqRanges = req.getHeaders(HttpHeader.RANGE.asString());
            HttpField contentEncoding = content.getContentEncoding();
            if (contentEncoding != null) {
                resp.setHeader(contentEncoding.getName(), contentEncoding.getValue());
            }
            releaseContent = this.sendData(req, resp, false, content, reqRanges);
        }
        finally {
            if (releaseContent && content != null) {
                content.release();
            }
        }
    }
}

