/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.objectbrowser;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.objectbrowser.ObjectBrowserView;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.ui.actions.AbstractToolHandler;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
class ToggleAutoRefreshHandler
extends AbstractToolHandler<RProcess>
implements IElementUpdater {
    private final ObjectBrowserView view;
    private boolean currentState;

    public ToggleAutoRefreshHandler(ObjectBrowserView view) {
        super("R", null, (ToolProvider)view, (IServiceLocator)view.getSite());
        this.view = view;
        this.init();
    }

    public void updateElement(UIElement element, Map parameters) {
        RWorkspace workspace;
        this.currentState = false;
        RProcess tool = (RProcess)this.getActiveTool();
        if (tool != null && (workspace = tool.getWorkspace()) != null) {
            this.currentState = workspace.isAutoRefreshEnabled();
        }
        WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, (UIElement)element);
        try {
            element.setChecked(this.currentState);
        }
        finally {
            WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
        }
    }

    protected @Nullable Object execute(RProcess tool, ExecutionEvent event) {
        RWorkspace workspace = tool.getWorkspace();
        if (workspace != null) {
            this.currentState = !this.currentState;
            workspace.setAutoRefresh(this.currentState);
        }
        return null;
    }
}

