/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.ts.core.RToolService;

public class ResolveCellIndexes {
    private final ToolRunnable findRunnable = new SystemRunnable(){

        public String getTypeId() {
            return "r/dataeditor/find";
        }

        public String getLabel() {
            return "Find Data (" + ResolveCellIndexes.this.dataProvider.getInput().getName() + ")";
        }

        public boolean canRunIn(Tool tool) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool process) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        ResolveCellIndexes.this.findScheduled = false;
                        break;
                    }
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            long[] coord;
            1 var4_3 = this;
            synchronized (var4_3) {
                coord = ResolveCellIndexes.this.index;
                ResolveCellIndexes.this.findScheduled = false;
            }
            if (coord == null || ResolveCellIndexes.this.dataProvider.getLockState() > 1) {
                return;
            }
            try {
                coord[1] = ResolveCellIndexes.this.resolveRowIdx(coord[1], (RToolService)service, m);
                ResolveCellIndexes.this.execute(coord[0], coord[1]);
            }
            catch (StatusException | UnexpectedRDataException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.ui", "An error occurred when resolving indexes for data viewer.", e));
            }
        }
    };
    private boolean findScheduled;
    private final AbstractRDataProvider<?> dataProvider;
    private long[] index;

    public ResolveCellIndexes(AbstractRDataProvider<?> dataProvider) {
        this.dataProvider = dataProvider;
    }

    public AbstractRDataProvider<?> getDataProvider() {
        return this.dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(long columnIdx, long rowIdx) {
        ToolRunnable toolRunnable = this.findRunnable;
        synchronized (toolRunnable) {
            this.index = null;
            if (this.dataProvider.getFilter() != null || this.dataProvider.getSortColumn() != null) {
                this.index = new long[]{columnIdx, rowIdx};
                if (!this.findScheduled) {
                    this.findScheduled = true;
                    this.dataProvider.schedule(this.findRunnable);
                }
                return;
            }
        }
        this.execute(columnIdx, rowIdx);
    }

    private long resolveRowIdx(long rowIdx, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        String revIndexName = this.dataProvider.checkRevIndex(r, m);
        if (revIndexName != null) {
            StringBuilder cmd = this.dataProvider.getRCmdStringBuilder();
            cmd.append("rj::.rj.tmp$").append(revIndexName).append('[').append(rowIdx + 1L).append(']');
            RVector vector = RDataUtils.checkRVector((RObject)r.evalData(cmd.toString(), m));
            RStore data = ((RVector)RDataUtils.checkLengthEqual((RObject)vector, (long)1L)).getData();
            if (data.isNA(0)) {
                return -1L;
            }
            return (data.getStoreType() == 2 ? (long)data.getInt(0) : (long)data.getNum(0)) - 1L;
        }
        return rowIdx;
    }

    protected void execute(long columnIndex, long rowIndex) {
    }
}

