/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.refactoring.Messages;
import org.eclipse.statet.r.core.refactoring.InlineTempRefactoring;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InlineTempWizard
extends RefactoringWizard {
    public InlineTempWizard(InlineTempRefactoring ref) {
        super((Refactoring)ref, 100);
        this.setDefaultPageTitle(Messages.InlineTemp_Wizard_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new InlineTempInputPage());
    }

    private static class InlineTempInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "InlineTemp.InputPage";

        public InlineTempInputPage() {
            super(PAGE_NAME);
        }

        protected InlineTempRefactoring getRefactoring() {
            return (InlineTempRefactoring)super.getRefactoring();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
            this.setControl((Control)composite);
            int count = this.getRefactoring().getReferencesCount();
            String variableName = this.getRefactoring().getVariableName();
            String title = NLS.bind((String)Messages.InlineTemp_Wizard_header, (Object)("`" + variableName + "`"));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            label.setText(title);
            label.setFont(JFaceResources.getBannerFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Label label2 = new Label(composite, 64);
            GridData gd = new GridData(4, 4, true, false, 2, 1);
            gd.widthHint = this.convertHorizontalDLUsToPixels(300);
            gd.heightHint = LayoutUtils.hintHeight((Label)label2, (int)3);
            label2.setLayoutData((Object)gd);
            if (count == 1) {
                label2.setText("No other references besides the selected assignment to the local variable found.");
            } else {
                label2.setText(NLS.bind((String)"An assignment and {0} references to the local variable found.", (Object)(count - 1)));
            }
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Dialog.applyDialogFont((Control)composite);
        }
    }
}

