/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.launching.ui;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.runtime.core.util.PathUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class RErrorLineTracker
implements IPatternMatchListener {
    private static final String NUM_LINE_REGEX = "^\\d++\\:\\ .*";
    private static final String ROUND_LINE_REGEX = "^[ \\t]*\\(.+\\:\\d+(?:\\-\\d+)?\\).*";
    private static final String COMBINED_REGEX = "(?:^\\d++\\:\\ .*)|(?:^[ \\t]*\\(.+\\:\\d+(?:\\-\\d+)?\\).*)";
    private static final Pattern NUM_LINE_PATTERN = Pattern.compile("^\\d++\\:\\ .*", 32);
    private static final Pattern NUM_LINE_GROUP_PATTERN = Pattern.compile("((\\d++)\\:)\\ .*", 32);
    private static final Pattern ROUND_LINE_GROUP_PATTERN = Pattern.compile("[ \\t]*\\(((.+)\\:(\\d+)(?:\\-\\d+)?)\\).*", 32);
    private TextConsole console;
    private IFileStore workingDirectory;
    private ToolProcess tool;
    private final Matcher numLineMatcher = NUM_LINE_PATTERN.matcher("");
    private final Matcher numLineGroupMatcher = NUM_LINE_GROUP_PATTERN.matcher("");
    private final Matcher checkLineGroupMatcher = ROUND_LINE_GROUP_PATTERN.matcher("");

    public RErrorLineTracker(IFileStore workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public RErrorLineTracker(ToolProcess tool) {
        this.tool = tool;
    }

    public int getCompilerFlags() {
        return 8;
    }

    public String getLineQualifier() {
        return null;
    }

    public String getPattern() {
        return COMBINED_REGEX;
    }

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        block6: {
            try {
                IDocument document = this.console.getDocument();
                String eventLine = document.get(event.getOffset(), event.getLength());
                if (this.numLineGroupMatcher.reset(eventLine).matches()) {
                    int srcLineNum = Integer.parseInt(this.numLineGroupMatcher.group(2));
                    IPath srcPath = this.createPath(this.searchPath(document, event));
                    if (srcPath != null) {
                        int begin = this.numLineGroupMatcher.start(1);
                        int length = this.numLineGroupMatcher.end(1) - begin;
                        this.console.addHyperlink((IHyperlink)new SourceLink(this.getWorkingDirectory(), srcPath, srcLineNum - 1), event.getOffset() + begin, length);
                    }
                    break block6;
                }
                if (this.checkLineGroupMatcher.reset(eventLine).matches()) {
                    IPath srcPath = this.createPath(this.checkLineGroupMatcher.group(2));
                    int srcLineNum = Integer.parseInt(this.checkLineGroupMatcher.group(3));
                    if (srcPath != null) {
                        int begin = this.checkLineGroupMatcher.start(1);
                        int length = this.checkLineGroupMatcher.end(1) - begin;
                        this.console.addHyperlink((IHyperlink)new SourceLink(this.getWorkingDirectory(), srcPath, srcLineNum - 1), event.getOffset() + begin, length);
                    }
                    break block6;
                }
                throw new IllegalStateException("match= " + eventLine);
            }
            catch (Exception e) {
                RUIPlugin.logError(-1, "Error while searching error line informations.", e);
            }
        }
    }

    private IPath createPath(String path) {
        if (path == null || (path = path.trim()).isEmpty()) {
            return null;
        }
        if (this.tool != null) {
            return this.tool.getWorkspace().createToolPath(path);
        }
        return PathUtils.check((IPath)new Path(path));
    }

    protected IFileStore getWorkingDirectory() {
        if (this.tool != null) {
            return this.tool.getWorkspace().getWorkspaceDir();
        }
        return this.workingDirectory;
    }

    private String searchPath(IDocument document, PatternMatchEvent event) throws BadLocationException {
        int line = document.getLineOfOffset(event.getOffset());
        block4: while (--line >= 0) {
            IRegion lineInfo = document.getLineInformation(line);
            int result = this.checkLine(document, lineInfo);
            switch (result) {
                case -2: {
                    break block4;
                }
                case -1: {
                    break;
                }
                default: {
                    return document.get(lineInfo.getOffset(), result - lineInfo.getOffset());
                }
            }
        }
        return null;
    }

    private int checkLine(IDocument doc, IRegion lineInfo) throws BadLocationException {
        int found;
        String s;
        IRegion prevLineInfo;
        int prevLineEnd;
        int offset = lineInfo.getOffset();
        int end = offset + Math.min(lineInfo.getLength(), 500);
        if (end - offset <= 2) {
            return -2;
        }
        char char0 = doc.getChar(offset);
        if (char0 >= '0' && char0 <= '9') {
            String s2 = doc.get(offset, Math.min(end - offset, 10));
            if (this.numLineMatcher.reset(s2).matches()) {
                return -1;
            }
            return -2;
        }
        if (offset >= 5 && !doc.get((prevLineEnd = (prevLineInfo = doc.getLineInformationOfOffset(offset - 1)).getOffset() + prevLineInfo.getLength()) - 3, 3).equals(" : ")) {
            return -2;
        }
        if (char0 == ' ') {
            s = doc.get(offset, end - offset);
            if (s.charAt(1) != ' ') {
                return -2;
            }
            found = s.indexOf(":", 4);
            if (found >= 0) {
                return offset + found;
            }
            return -2;
        }
        if (char0 == '\t') {
            s = doc.get(offset, end - offset);
            found = s.indexOf(":", 3);
            if (found >= 0) {
                return offset + found;
            }
            return -2;
        }
        return -2;
    }

    private static class SourceLink
    implements IHyperlink {
        private final IFileStore pathBaseFolder;
        private final IPath path;
        private final int line;

        public SourceLink(IFileStore pathBaseFolder, IPath path, int line) {
            this.pathBaseFolder = pathBaseFolder;
            this.path = path;
            this.line = line;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            FileValidator fileValidator = new FileValidator(true);
            fileValidator.setOnDirectory(4);
            fileValidator.setResourceLabel(RLaunchingMessages.RErrorLineTracker_File_name);
            if (this.path.isAbsolute()) {
                fileValidator.setExplicit((Object)this.path);
            } else {
                fileValidator.setExplicit((Object)URIUtil.toPath((URI)this.pathBaseFolder.toURI()).append(this.path).makeAbsolute());
            }
            IStatus status = fileValidator.validate(null);
            if (status.getSeverity() == 4) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, NLS.bind((String)RLaunchingMessages.RErrorLineTracker_error_GetFile_message, (Object)this.path), (Throwable)new CoreException(status)), 3);
                return;
            }
            IFile wsFile = (IFile)fileValidator.getWorkspaceResource();
            try {
                IEditorPart editor = wsFile != null ? IDE.openEditor((IWorkbenchPage)UIAccess.getActiveWorkbenchPage((boolean)true), (IFile)wsFile, (String)"org.eclipse.statet.r.editors.R", (boolean)true) : IDE.openEditor((IWorkbenchPage)UIAccess.getActiveWorkbenchPage((boolean)true), (URI)fileValidator.getFileStore().toURI(), (String)"org.eclipse.statet.r.editors.R", (boolean)true);
                AbstractTextEditor textEditor = (AbstractTextEditor)editor;
                IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                if (documentProvider != null) {
                    IDocument doc = documentProvider.getDocument((Object)textEditor.getEditorInput());
                    IRegion lineInfo = doc.getLineInformation(this.line);
                    textEditor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
                }
            }
            catch (BadLocationException | PartInitException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, NLS.bind((String)RLaunchingMessages.RErrorLineTracker_error_OpeningFile_message, (Object)this.path), e), 3);
            }
        }
    }
}

