/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.jface.resource.ImageDescriptorRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.debug.ui.breakpoints.BreakpointsHelper;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RDebugUIPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.r.debug.ui";
    private static final String R_IMAGES_ID = "org.eclipse.statet.r.images";
    public static final String IMG_OBJ_R_BREAKPOINT = "org.eclipse.statet.r.images/obj/r_breakpoint";
    public static final String IMG_OBJ_R_BREAKPOINT_DISABLED = "org.eclipse.statet.r.images/obj/r_breakpoint.disabled";
    public static final String IMG_OBJ_R_TOPLEVEL_BREAKPOINT = "org.eclipse.statet.r.images/obj/r_toplevel_breakpoint";
    public static final String IMG_OBJ_R_TOPLEVEL_BREAKPOINT_DISABLED = "org.eclipse.statet.r.images/obj/r_toplevel_breakpoint.disabled";
    public static final String IMG_OBJ_R_EXCEPTION_BREAKPOINT = "org.eclipse.statet.r.images/obj/r_exception";
    public static final String IMG_OBJ_R_EXCEPTION_BREAKPOINT_DISABLED = "org.eclipse.statet.r.images/obj/r_exception.disabled";
    public static final String IMG_OBJ_R_INSPECT_EXPRESSION = "org.eclipse.statet.r.images/obj/r_inspect_expression";
    public static final String IMG_OBJ_R_SOURCE_FROM_RUNTIME = "org.eclipse.statet.r.images/obj/r_source.runtime";
    private static RDebugUIPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private ImageDescriptorRegistry imageDescriptorRegistry;
    private BreakpointsHelper breakpointsHelper;

    public static RDebugUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        RDebugUIPlugin plugin = RDebugUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.breakpointsHelper = new BreakpointsHelper();
        this.disposables.add(this.breakpointsHelper);
        RDebugUIPlugin rDebugUIPlugin = this;
        synchronized (rDebugUIPlugin) {
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RDebugUIPlugin rDebugUIPlugin = this;
            synchronized (rDebugUIPlugin) {
                this.started = false;
                this.imageDescriptorRegistry = null;
                this.breakpointsHelper = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RDebugUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(IMG_OBJ_R_BREAKPOINT, "obj_16", "r_breakpoint.png");
        util.register(IMG_OBJ_R_BREAKPOINT_DISABLED, "obj_16", "r_breakpoint-disabled.png");
        util.register(IMG_OBJ_R_TOPLEVEL_BREAKPOINT, "obj_16", "r_toplevel_breakpoint.png");
        util.register(IMG_OBJ_R_TOPLEVEL_BREAKPOINT_DISABLED, "obj_16", "r_toplevel_breakpoint-disabled.png");
        util.register(IMG_OBJ_R_EXCEPTION_BREAKPOINT, "obj_16", "r_exception.png");
        util.register(IMG_OBJ_R_EXCEPTION_BREAKPOINT_DISABLED, "obj_16", "r_exception-disabled.png");
        util.register(IMG_OBJ_R_INSPECT_EXPRESSION, "obj_16", "r_insp_expression.png");
        util.register(IMG_OBJ_R_SOURCE_FROM_RUNTIME, "obj_16", "r_source-runtime.png");
    }

    public synchronized ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.imageDescriptorRegistry;
    }
}

