/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.core.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class OperatorRule
implements IRule {
    private final CharLevel firstLevel = new CharLevel();

    public OperatorRule(char[] init) {
        this.firstLevel.list = new CharLeaf[init.length];
        int i = 0;
        while (i < init.length) {
            this.firstLevel.list[i] = new CharLeaf(null, new char[]{init[i]}, null);
            ++i;
        }
    }

    public void addOp(String op, IToken token) {
        char[] cOp = op.toCharArray();
        this.firstLevel.add(op, cOp, token);
    }

    public void addOps(String[] ops, IToken token) {
        int i = 0;
        while (i < ops.length) {
            this.addOp(ops[i], token);
            ++i;
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        CharLeaf matchLeaf = this.searchLeaf(scanner);
        if (matchLeaf != null) {
            return matchLeaf.leafToken;
        }
        return Token.UNDEFINED;
    }

    public String searchString(ICharacterScanner scanner) {
        CharLeaf matchLeaf = this.searchLeaf(scanner);
        if (matchLeaf != null) {
            return matchLeaf.leafId;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private CharLeaf searchLeaf(ICharacterScanner scanner) {
        searchLevel = this.firstLevel;
        level = 1;
        matchLeaf = null;
        matchLevel = 0;
        while (true) {
            block3: {
                c = scanner.read();
                leaf = null;
                if (c >= 0) break block3;
                --level;
                ** GOTO lbl21
            }
            if (searchLevel == null || (leaf = searchLevel.getChild((char)c)) == null) ** GOTO lbl21
            if (leaf.leafId != null) {
                matchLeaf = leaf;
                matchLevel = level;
            }
            searchLevel = leaf.nextLevel;
            ++level;
        }
lbl-1000:
        // 1 sources

        {
            scanner.unread();
            --level;
lbl21:
            // 3 sources

            ** while (level > matchLevel)
        }
lbl22:
        // 1 sources

        return matchLeaf;
    }

    private class CharLeaf {
        private final char leafChar;
        private IToken leafToken;
        private CharLevel nextLevel;
        private String leafId;

        private CharLeaf(String id, char[] chars, IToken token) {
            this.leafChar = chars[0];
            this.add(id, chars, token);
        }

        private void add(String id, char[] chars, IToken token) {
            if (chars.length == 1) {
                this.leafId = id;
                this.leafToken = token;
            } else {
                char[] nextChars = new char[chars.length - 1];
                System.arraycopy(chars, 1, nextChars, 0, nextChars.length);
                if (this.nextLevel == null) {
                    this.nextLevel = new CharLevel();
                }
                this.nextLevel.add(id, nextChars, token);
            }
        }
    }

    private class CharLevel {
        private CharLeaf[] list = new CharLeaf[0];

        private CharLevel() {
        }

        private CharLeaf getChild(char c) {
            int i = 0;
            while (i < this.list.length) {
                if (this.list[i].leafChar == c) {
                    return this.list[i];
                }
                ++i;
            }
            return null;
        }

        private void add(String id, char[] carray, IToken token) {
            CharLeaf leaf = this.getChild(carray[0]);
            if (leaf == null) {
                CharLeaf[] extList = new CharLeaf[this.list.length + 1];
                System.arraycopy(this.list, 0, extList, 0, this.list.length);
                extList[this.list.length] = new CharLeaf(id, carray, token);
                this.list = extList;
            } else {
                leaf.add(id, carray, token);
            }
        }
    }
}

