/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ast.core.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public class AstSelection {
    public static final int MODE_COVERING_GREATER = 1;
    public static final int MODE_COVERING_SAME_FIRST = 2;
    public static final int MODE_COVERING_SAME_LAST = 3;
    private static final int SEARCH_STATE_BEFORE = -1;
    private static final int SEARCH_STATE_MATCH = 0;
    private static final int SEARCH_STATE_MATCHED = 1;
    private static final int SEARCH_STATE_BEHIND = 2;
    private int start;
    private int stop;
    private @Nullable AstNode lastCovering;
    private @Nullable AstNode beforeChild;
    private @Nullable AstNode firstChild;
    private @Nullable AstNode lastChild;
    private @Nullable AstNode afterChild;

    AstSelection() {
    }

    protected final void clearChilds() {
        this.beforeChild = null;
        this.firstChild = null;
        this.lastChild = null;
        this.afterChild = null;
    }

    protected final void checkChild(AstNode node) {
        if (node.getEndOffset() < this.start) {
            this.beforeChild = node;
            return;
        }
        if (node.getStartOffset() > this.stop) {
            if (this.afterChild == null) {
                this.afterChild = node;
            }
            return;
        }
        if (this.firstChild == null) {
            this.firstChild = node;
        }
        this.lastChild = node;
    }

    public static AstSelection search(AstNode rootNode, int start, int stop, int mode) {
        AstSelection selection = new AstSelection();
        selection.start = start;
        selection.stop = stop;
        AstVisitor finder = switch (mode) {
            case 1 -> selection.new CoveringGreaterFinder();
            case 2 -> selection.new CoveringSameFirstFinder();
            case 3 -> selection.new CoveringSameLastFinder();
            default -> throw new IllegalArgumentException("Wrong search mode");
        };
        try {
            finder.visit(rootNode);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return selection;
    }

    public int getStartOffset() {
        return this.start;
    }

    public int getStopOffset() {
        return this.stop;
    }

    public final @Nullable AstNode getCovering() {
        return this.lastCovering;
    }

    public final @Nullable AstNode getChildBefore() {
        return this.beforeChild;
    }

    public final @Nullable AstNode getChildFirstTouching() {
        return this.firstChild;
    }

    public final @Nullable AstNode getChildLastTouching() {
        return this.lastChild;
    }

    public final @Nullable AstNode getChildAfter() {
        return this.afterChild;
    }

    private class CoveringGreaterFinder
    implements AstVisitor {
        private int inCovering = -1;

        private CoveringGreaterFinder() {
        }

        @Override
        public void visit(AstNode node) throws InvocationTargetException {
            if (this.inCovering >= 2) {
                return;
            }
            if (node.getStartOffset() < AstSelection.this.start && AstSelection.this.stop <= node.getEndOffset() || node.getStartOffset() == AstSelection.this.start && AstSelection.this.stop < node.getEndOffset()) {
                AstSelection.this.clearChilds();
                AstSelection.this.lastCovering = node;
                this.inCovering = 0;
                node.acceptInChildren(this);
                this.inCovering = AstSelection.this.start == AstSelection.this.stop && node.getEndOffset() == AstSelection.this.stop ? 1 : 2;
                return;
            }
            if (this.inCovering == 0) {
                AstSelection.this.checkChild(node);
                return;
            }
            if (this.inCovering == 1) {
                this.inCovering = 2;
            }
        }
    }

    private class CoveringSameFirstFinder
    implements AstVisitor {
        private int inCovering = -1;

        private CoveringSameFirstFinder() {
        }

        @Override
        public void visit(AstNode node) throws InvocationTargetException {
            if (this.inCovering >= 2) {
                return;
            }
            if (node.getStartOffset() <= AstSelection.this.start && AstSelection.this.stop <= node.getEndOffset()) {
                AstSelection.this.clearChilds();
                AstSelection.this.lastCovering = node;
                if (node.getStartOffset() != AstSelection.this.start || AstSelection.this.stop != node.getEndOffset()) {
                    this.inCovering = 0;
                    node.acceptInChildren(this);
                }
                this.inCovering = 2;
                return;
            }
            if (this.inCovering == 0) {
                AstSelection.this.checkChild(node);
                return;
            }
        }
    }

    private class CoveringSameLastFinder
    implements AstVisitor {
        private int inCovering = -1;

        private CoveringSameLastFinder() {
        }

        @Override
        public void visit(AstNode node) throws InvocationTargetException {
            if (this.inCovering >= 2) {
                return;
            }
            if (node.getStartOffset() <= AstSelection.this.start && AstSelection.this.stop <= node.getEndOffset()) {
                AstSelection.this.clearChilds();
                AstSelection.this.lastCovering = node;
                this.inCovering = 0;
                node.acceptInChildren(this);
                this.inCovering = 2;
                return;
            }
            if (this.inCovering == 0) {
                AstSelection.this.checkChild(node);
                return;
            }
        }
    }
}

