/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.docmlet.tex.core.model.TexModel;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.source.doc.LtxDocumentSetupParticipant;
import org.eclipse.statet.docmlet.tex.ui.editors.TexEditorBuild;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;

@NonNullByDefault
public class LtxDocumentProvider
extends SourceDocumentProvider<TexSourceUnit>
implements Disposable {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SettingsChangeNotifier.ChangeListener editorPrefListener;
    private boolean handleTemporaryProblems;

    public LtxDocumentProvider() {
        super("Ltx", (PartitionerDocumentSetupParticipant)new LtxDocumentSetupParticipant(), TexEditorBuild.LTX_ISSUE_TYPE_SET);
        SettingsChangeNotifier.ChangeListener editorPrefListener;
        this.editorPrefListener = editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

            public void settingsChanged(Set<String> groupIds) {
                if (groupIds.contains("Tex/editor/build")) {
                    LtxDocumentProvider.this.updateEditorPrefs();
                }
            }
        };
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(editorPrefListener);
        PreferenceAccess access = EPreferences.getInstancePrefs();
        this.handleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        SettingsChangeNotifier.ChangeListener editorPrefListener = this.editorPrefListener;
        if (editorPrefListener != null) {
            this.editorPrefListener = null;
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(editorPrefListener);
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = EPreferences.getInstancePrefs();
        boolean newHandleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryProblems != newHandleTemporaryProblems) {
            this.handleTemporaryProblems = newHandleTemporaryProblems;
            TexModel.getLtxModelManager().refresh(Ltk.EDITOR_CONTEXT);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource, LtxDocumentProvider.this.getIssueTypeSet());
        }

        protected boolean isHandlingTemporaryProblems(IssueTypeSet.ProblemCategory issueCategory) {
            return LtxDocumentProvider.this.handleTemporaryProblems;
        }
    }
}

