/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;

@NonNullByDefault
public class RUniqueCharacter32Store
extends RCharacter32Store {
    public RUniqueCharacter32Store() {
    }

    public RUniqueCharacter32Store(@Nullable String[] initialValues) {
        super(initialValues, initialValues.length);
    }

    RUniqueCharacter32Store(RCharacter32Store source, boolean reuse) {
        super(source, reuse);
    }

    public RUniqueCharacter32Store(RJIO io, int length) throws IOException {
        super(io, length);
    }

    @Override
    public void setNA(long idx) {
        if (idx < 0L || idx >= this.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.setNA((int)idx);
    }

    @Override
    public void setNA(int idx) {
        long currentIdx = this.indexOfNA();
        if (currentIdx >= 0L) {
            if (currentIdx == (long)idx) {
                return;
            }
            throw new IllegalArgumentException();
        }
        super.setNA(idx);
    }

    @Override
    public void insertNA(int idx) {
        if (this.indexOfNA() >= 0L) {
            throw new IllegalArgumentException();
        }
        super.insertNA(idx);
    }

    @Override
    public void insertNA(int[] idxs) {
        switch (idxs.length) {
            case 0: {
                return;
            }
            case 1: {
                this.insertNA(idxs[0]);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setChar(int idx, String value) {
        long currentIdx = this.indexOf(value);
        if (currentIdx >= 0L) {
            if (currentIdx == (long)idx) {
                return;
            }
            throw new IllegalArgumentException();
        }
        super.setChar(idx, value);
    }

    @Override
    public void setChar(long idx, String value) {
        if (idx < 0L || idx >= this.getLength()) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        this.setChar((int)idx, value);
    }

    @Override
    public void insertChar(int idx, String value) {
        if (this.indexOf(value) >= 0L) {
            throw new IllegalArgumentException();
        }
        super.insertChar(idx, value);
    }

    protected void insertAuto(int idx) {
        this.insertChar(idx, this.createAuto(idx));
    }

    protected String createAuto(int idx) {
        String nr = Integer.toString(idx + 1);
        if (this.indexOf(nr) < 0L) {
            return nr;
        }
        int i = 1;
        String sub;
        while (this.indexOf(sub = nr + "." + Integer.toString(i)) >= 0L) {
            ++i;
        }
        return sub;
    }
}

