/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.CodeSource;
import org.eclipse.statet.jcommons.io.ArchiveUrl;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class ClassLoaderUtils {
    public static String getClassLocationUrlString(Class<?> refClass) {
        String urlString = ClassLoaderUtils.getUrlStringByClassloader(refClass);
        return urlString;
    }

    private static String getUrlStringByDomain(Class<?> refClass) {
        try {
            CodeSource source = refClass.getProtectionDomain().getCodeSource();
            if (source == null) {
                throw new UnsupportedOperationException("CodeSource not available");
            }
            URI url = source.getLocation().toURI();
            String s = url.toString();
            if (s.endsWith(".jar")) {
                StringBuilder sb = new StringBuilder(s.length());
                if (!UriUtils.isJarUrl(s)) {
                    sb.append("jar:");
                }
                sb.append(s);
                sb.append("!/");
                return sb.toString();
            }
            return s;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("getUrlStringByDomain failed (refClass= %1$s)", refClass.getName()), e);
        }
    }

    private static String getUrlStringByClassloader(Class<?> refClass) {
        try {
            String resourceName = refClass.getName().replace('.', '/') + ".class";
            URI url = refClass.getClassLoader().getResource(resourceName).toURI();
            String s = url.toString();
            if (s.endsWith(resourceName)) {
                return s.substring(0, s.length() - resourceName.length());
            }
            throw new UnsupportedOperationException("url= " + String.valueOf(url));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("getUrlStringByClassloader failed (refClass= %1$s)", refClass.getName()), e);
        }
    }

    public static String toJClassPathEntryString(String urlString) {
        try {
            URI fileUrl;
            ArchiveUrl archiveUrl = UriUtils.getArchiveUrl(urlString);
            if (archiveUrl != null && !archiveUrl.isNested()) {
                fileUrl = archiveUrl.getOuterArchiveUrl();
            } else if (UriUtils.isFileUrl(urlString)) {
                fileUrl = new URI(urlString);
            } else {
                throw new UnsupportedOperationException("url= " + urlString);
            }
            Path path = Path.of(fileUrl);
            return path.toString();
        }
        catch (URISyntaxException e) {
            throw new UnsupportedOperationException("url= " + urlString, e);
        }
    }

    private ClassLoaderUtils() {
    }
}

