/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonRegex;
import org.eclipse.statet.jcommons.io.UriUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;

@NonNullByDefault
public class References {
    public static final String REF_LABEL_REGEX = "(?:\\\\.|[^\\[\\]]){0,1000}";
    private static final String D_QUOTED_TITLE_REGEX = "\"(?:\\\\.|[^\"])*\"";
    private static final String S_QUOTED_TITLE_REGEX = "'(?:\\\\.|[^'])*'";
    private static final String PARENS_TITLE_REGEX = "\\((?:\\\\.|[^\\)])*\\)";
    public static final String REF_TITLE_REGEX = "\"(?:\\\\.|[^\"])*\"|'(?:\\\\.|[^'])*'|\\((?:\\\\.|[^\\)])*\\)";

    /*
     * Unable to fully structure code
     */
    public static @Nullable LinkDestination readLinkDestination(String text, int offset) {
        block24: {
            beginOffset = offset;
            while (offset < text.length() && CommonRegex.isWhitespace(text.charAt(offset))) {
                ++offset;
            }
            if (offset >= text.length()) break block24;
            if (text.charAt(offset) == '<') {
                linkBeginOffset = ++offset;
                while (offset < text.length()) {
                    switch (text.charAt(offset)) {
                        case '\n': 
                        case '\r': {
                            return null;
                        }
                        case '\\': {
                            if (++offset >= text.length()) {
                                return null;
                            }
                            switch (text.charAt(offset)) {
                                case '\n': 
                                case '\r': {
                                    return null;
                                }
                            }
                            break;
                        }
                        case '<': {
                            return null;
                        }
                        case '>': {
                            return new LinkDestination(beginOffset, offset + 1, text.substring(linkBeginOffset, offset));
                        }
                    }
                    ++offset;
                }
                return null;
            }
            linkBeginOffset = offset;
            bracketLevels = 0;
            block20: while (offset < text.length()) {
                switch (text.charAt(offset)) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': 
                    case ' ': {
                        break block20;
                    }
                    case '\\': {
                        if (++offset >= text.length()) {
                            return null;
                        }
                        switch (text.charAt(offset)) {
                            case '\u0000': 
                            case '\u0001': 
                            case '\u0002': 
                            case '\u0003': 
                            case '\u0004': 
                            case '\u0005': 
                            case '\u0006': 
                            case '\u0007': 
                            case '\b': 
                            case '\t': 
                            case '\n': 
                            case '\u000b': 
                            case '\f': 
                            case '\r': 
                            case '\u000e': 
                            case '\u000f': 
                            case '\u0010': 
                            case '\u0011': 
                            case '\u0012': 
                            case '\u0013': 
                            case '\u0014': 
                            case '\u0015': 
                            case '\u0016': 
                            case '\u0017': 
                            case '\u0018': 
                            case '\u0019': 
                            case '\u001a': 
                            case '\u001b': 
                            case '\u001c': 
                            case '\u001d': 
                            case '\u001e': 
                            case '\u001f': 
                            case ' ': {
                                return null;
                            }
                        }
                        ** GOTO lbl44
                    }
                    case '(': {
                        ++bracketLevels;
                        ** GOTO lbl44
                    }
                    case ')': {
                        if (--bracketLevels < 0) break block20;
                    }
lbl44:
                    // 4 sources

                    default: {
                        ++offset;
                    }
                }
            }
            return new LinkDestination(beginOffset, offset, text.substring(linkBeginOffset, offset));
        }
        return null;
    }

    public static String normalizeUri(String uri) {
        try {
            String decodedUri = URLDecoder.decode(uri, StandardCharsets.UTF_8);
            return References.encodeUri(decodedUri);
        }
        catch (Exception e) {
            return uri;
        }
    }

    public static String encodeUri(String decodedUri) {
        int idxHash = decodedUri.indexOf(35);
        if (idxHash >= 0) {
            StringBuilder normUri = new StringBuilder(decodedUri.length() + 10);
            normUri.append(UriUtils.encodeFragment((String)decodedUri.substring(0, idxHash)));
            normUri.append('#');
            if (idxHash + 1 < decodedUri.length()) {
                normUri.append(UriUtils.encodeFragment((String)decodedUri.substring(idxHash + 1, decodedUri.length())));
            }
            return normUri.toString();
        }
        return UriUtils.encodeFragment((String)decodedUri);
    }

    private References() {
    }

    public static class LinkDestination
    extends BasicTextRegion {
        private final String escapedUri;

        public LinkDestination(int startOffset, int endOffset, String escapedUri) {
            super(startOffset, endOffset);
            this.escapedUri = escapedUri;
        }

        public String getEscapedUri() {
            return this.escapedUri;
        }
    }
}

