/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.ui.swt.SwtUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.css.StylingUtils;
import org.eclipse.statet.jcommons.graphic.core.ColorDef;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.nico.ui.console.NIConsoleStreamAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class PromptHighlighter
implements IPropertyChangeListener {
    private Control control;
    private final IPreferenceStore preferenceStore;
    private final PreferenceAccess prefAccess;
    private @Nullable Color foregroundColor;
    private @Nullable Color backgroundColor;
    private boolean isHighlightEnabled;

    public PromptHighlighter(Control control, PreferenceAccess prefAccess, IPreferenceStore preferenceStore) {
        this.control = control;
        StylingUtils.disableStyling((Control)control);
        this.prefAccess = prefAccess;
        this.preferenceStore = preferenceStore;
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateControl();
    }

    public void dispose() {
        this.control = null;
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("currentLineColor")) {
            Display.getDefault().asyncExec(() -> {
                this.updateSettings();
                this.updateControl();
            });
        }
    }

    public void setHighlight(boolean enable) {
        if (enable == this.isHighlightEnabled) {
            return;
        }
        this.isHighlightEnabled = enable;
        this.updateControl();
    }

    public void updateSettings() {
        this.foregroundColor = null;
        this.backgroundColor = null;
    }

    public void updateControl() {
        Color backgroundColor;
        Color foregroundColor;
        Control control = this.control;
        if (!UIAccess.isOkToUse((Control)control)) {
            return;
        }
        if (this.isHighlightEnabled) {
            foregroundColor = this.foregroundColor;
            if (foregroundColor == null) {
                this.foregroundColor = foregroundColor = SwtUtils.getColors().get((ColorDef)ObjectUtils.nonNullAssert((Object)((ColorDef)this.prefAccess.getPreferenceValue((Preference)NIConsoleStreamAdapter.getForegroundColorPref("org.eclipse.statet.nico.ui.InfoStream")))));
            }
            if ((backgroundColor = this.backgroundColor) == null) {
                this.backgroundColor = backgroundColor = SwtUtils.getColors().get(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)"currentLineColor"));
            }
        } else {
            foregroundColor = control.getDisplay().getSystemColor(39);
            backgroundColor = null;
        }
        control.setForeground(foregroundColor);
        control.setBackground(backgroundColor);
    }
}

