/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.swt.util.ControlEnableStates;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

@NonNullByDefault
public class ExtStatusDialog
extends StatusDialog
implements IRunnableContext {
    protected static final int WITH_RUNNABLE_CONTEXT = 1;
    protected static final int WITH_DATABINDING_CONTEXT = 2;
    protected static final int SHOW_INITIAL_STATUS = 4;
    private static final IStatus NO_STATUS = new Status(0, "org.eclipse.jface", 0, "", null);
    private final int options;
    private Composite progressComposite = (Composite)ObjectUtils.nonNullLateInit();
    private ProgressMonitorPart progressMonitorPart = (ProgressMonitorPart)ObjectUtils.nonNullLateInit();
    private int activeRunningOperations;
    private @Nullable Control progressLastFocusControl;
    private @Nullable ControlEnableStates progressLastContentEnableState;
    private DataBindingSupport dataBinding = (DataBindingSupport)ObjectUtils.nonNullLateInit();

    public ExtStatusDialog(@Nullable Shell parent) {
        this(parent, 0);
    }

    public ExtStatusDialog(@Nullable Shell parent, int options) {
        super(parent);
        this.options = options;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        Point savedSize = super.getInitialSize();
        Point minSize = this.getShell().computeSize(-1, -1);
        return new Point(Math.max(savedSize.x, minSize.x), Math.max(savedSize.y, minSize.y));
    }

    public void create() {
        super.create();
        Button button = this.getButton(0);
        Shell shell = this.getShell();
        if (button != null && shell != null && !shell.isDisposed()) {
            shell.setDefaultButton(button);
        }
        if ((this.options & 2) != 0) {
            this.initBindings();
        }
    }

    protected void initBindings() {
        DataBindingSupport databinding = new DataBindingSupport(this.getDialogArea());
        this.addBindings(databinding);
        databinding.installStatusListener(new StatusUpdater());
        if ((this.options & 4) == 0) {
            IStatus status = this.getStatus();
            this.updateStatus(Status.OK_STATUS);
            this.updateButtonsEnableState(status);
        }
        this.dataBinding = databinding;
    }

    protected void addBindings(DataBindingSupport db) {
    }

    protected DataBindingSupport getDataBinding() {
        return this.dataBinding;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.verticalSpacing = 0;
        if ((this.options & 1) != 0) {
            Composite monitorComposite = this.createMonitorComposite(composite);
            Control[] children = composite.getChildren();
            layout.numColumns = 3;
            ++((GridData)children[0].getLayoutData()).horizontalSpan;
            monitorComposite.moveBelow(children[1]);
            monitorComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        return composite;
    }

    private Composite createMonitorComposite(Composite parent) {
        this.progressComposite = new Composite(parent, 0);
        GridLayout layout = LayoutUtils.newCompositeGrid(2);
        layout.marginLeft = LayoutUtils.defaultHMargin();
        this.progressComposite.setLayout((Layout)layout);
        this.progressMonitorPart = new ProgressMonitorPart(this.progressComposite, null, true);
        this.progressMonitorPart.setLayoutData((Object)new GridData(4, 128, true, false));
        Dialog.applyDialogFont((Control)this.progressComposite);
        this.progressComposite.setVisible(false);
        return this.progressComposite;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if ((this.options & 1) == 0) {
            throw new UnsupportedOperationException();
        }
        if (this.getShell() != null && this.getShell().isVisible()) {
            if (this.activeRunningOperations == 0) {
                Control focusControl = this.getShell().getDisplay().getFocusControl();
                if (focusControl != null && focusControl.getShell() != this.getShell()) {
                    focusControl = null;
                }
                this.progressLastFocusControl = focusControl;
                ArrayList<Control> disable = new ArrayList<Control>();
                disable.add((Control)ObjectUtils.nonNullAssert((Object)this.getDialogArea()));
                Control[] controlArray = this.getButton(0).getParent().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (child instanceof Button) {
                        disable.add(child);
                    }
                    ++n2;
                }
                this.progressLastContentEnableState = ControlEnableStates.disable(disable);
                this.progressMonitorPart.attachToCancelComponent(null);
                this.progressComposite.setVisible(true);
            }
            ++this.activeRunningOperations;
            try {
                ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.progressMonitorPart, (Display)this.getShell().getDisplay());
            }
            finally {
                --this.activeRunningOperations;
                if (this.activeRunningOperations == 0 && this.getShell() != null) {
                    Control focusControl;
                    this.progressComposite.setVisible(false);
                    this.progressMonitorPart.removeFromCancelComponent(null);
                    ControlEnableStates contentEnableState = this.progressLastContentEnableState;
                    if (contentEnableState != null) {
                        this.progressLastContentEnableState = null;
                        contentEnableState.restore();
                    }
                    if ((focusControl = this.progressLastFocusControl) != null) {
                        this.progressLastFocusControl = null;
                        focusControl.setFocus();
                    }
                }
            }
        } else {
            PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
        }
    }

    protected boolean isOperationRunning() {
        return this.activeRunningOperations > 0;
    }

    protected void clearStatus() {
        this.updateStatus(NO_STATUS);
    }

    protected void updateButtonsEnableState(IStatus status) {
        if (this.isOperationRunning()) {
            ControlEnableStates contentEnableState = this.progressLastContentEnableState;
            Button okButton = this.getButton(0);
            if (contentEnableState != null && okButton != null && !okButton.isDisposed()) {
                contentEnableState.updateState((Control)okButton, false, !status.matches(4));
            }
        } else {
            super.updateButtonsEnableState(status);
        }
    }

    public class StatusUpdater
    implements StatusChangeListener {
        public void statusChanged(IStatus status) {
            ExtStatusDialog.this.updateStatus(status);
        }
    }
}

