/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SearchContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserAddressBar;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.ManagedPage;
import org.eclipse.statet.ecommons.ui.mpbv.ManagedPageBookView;
import org.eclipse.statet.ecommons.ui.util.BrowserUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.StatusLineMessageManager;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class PageBookBrowserPage
extends ManagedPage<ManagedPageBookView<BrowserSession>>
implements ProgressListener,
LocationListener,
TitleListener,
StatusTextListener,
OpenWindowListener,
CloseWindowListener {
    private static final String STATIC_CONTENT_SCHEME = "estatic";
    private static final String STATIC_CONTENT_URL_PREFIX = "estatic:///";
    protected static final String ABOUT_BLANK_URI_STRING = "about:blank";
    protected static final URI ABOUT_BLANK_URI = URI.create("about:blank");
    private final BrowserSession session;
    private Composite composite;
    private Browser browser;
    private @Nullable SearchBar searchBar;
    private @Nullable IStatus browserStatus;
    private int progressTotal;
    private int progressWorked;
    private @Nullable StatusLineMessageManager statusManager;
    private @Nullable BrowserAddressBar addressBar;

    protected static void setIcon(BrowserSession session, ImageDescriptor imageDescriptor) {
        session.setImageDescriptor(imageDescriptor);
    }

    public PageBookBrowserPage(ManagedPageBookView view, BrowserSession session) {
        super(view);
        this.session = session;
    }

    public BrowserSession getSession() {
        return this.session;
    }

    @Override
    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0){

            public boolean setFocus() {
                return PageBookBrowserPage.this.setDefaultFocus();
            }
        };
        this.composite.setLayout((Layout)LayoutUtils.newSashGrid());
        Control control = this.createAddressBar(this.composite);
        if (control != null) {
            control.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Control browser = this.createBrowser(this.composite);
        browser.setLayoutData((Object)new GridData(4, 4, true, true));
        super.createControl(null);
        String url = this.session.getUrl();
        if (!url.isEmpty()) {
            this.setUrl(url);
        }
    }

    private Control createBrowser(Composite parent) {
        Browser browser;
        this.browser = browser = new Browser(parent, 0);
        browser.addProgressListener((ProgressListener)this);
        browser.addLocationListener((LocationListener)this);
        browser.addTitleListener((TitleListener)this);
        browser.addStatusTextListener((StatusTextListener)this);
        browser.addOpenWindowListener((OpenWindowListener)this);
        browser.addCloseWindowListener((CloseWindowListener)this);
        browser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) != 0 && e.keyCode == 114) {
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) != 0 && e.keyCode == 114) {
                    e.doit = false;
                }
            }
        });
        return browser;
    }

    protected @Nullable Control createAddressBar(Composite parent) {
        BrowserAddressBar addressBar;
        this.addressBar = addressBar = new BrowserAddressBar(parent, this, BrowserUtils.getDefaultAddressInputHistory());
        return addressBar;
    }

    void setStatusManager(@Nullable StatusLineMessageManager statusManager) {
        this.statusManager = statusManager;
        if (statusManager != null) {
            statusManager.setSelectionMessage(this.browserStatus);
        }
    }

    @Override
    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        IHandlerService handlerService = handlers.getHandlerService();
        String browserType = this.browser.getBrowserType();
        if (browserType.equals("mozilla") || browserType.equals("webkit")) {
            AbstractHandler handler = new AbstractHandler(){

                public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
                    if (!UIAccess.isOkToUse((Control)PageBookBrowserPage.this.browser)) {
                        return null;
                    }
                    SearchBar searchBar = PageBookBrowserPage.this.searchBar;
                    if (searchBar == null) {
                        PageBookBrowserPage.this.searchBar = searchBar = new SearchBar(PageBookBrowserPage.this.composite);
                    }
                    searchBar.show();
                    return null;
                }
            };
            handlers.addActivate("org.eclipse.ui.edit.findReplace", (IHandler2)handler);
            handler = new AbstractHandler(){

                public @Nullable Object execute(ExecutionEvent arg0) {
                    PageBookBrowserPage.this.search(true);
                    return null;
                }
            };
            handlers.add("org.eclipse.ui.edit.findNext", (IHandler2)handler);
            handlerService.activateHandler("org.eclipse.ui.navigate.next", (IHandler)handler);
            handler = new AbstractHandler(){

                public @Nullable Object execute(ExecutionEvent arg0) {
                    PageBookBrowserPage.this.search(false);
                    return null;
                }
            };
            handlers.add("org.eclipse.ui.edit.findPrevious", (IHandler2)handler);
            handlerService.activateHandler("org.eclipse.ui.navigate.previous", (IHandler)handler);
        }
    }

    private void search(boolean forward) {
        String message;
        SearchBar searchBar = this.searchBar;
        if (searchBar == null || !UIAccess.isOkToUse((Control)this.browser)) {
            return;
        }
        String text = searchBar.getText();
        if (text == null || text.isEmpty()) {
            return;
        }
        boolean caseSensitive = searchBar.isCaseSensitiveEnabled();
        if (BrowserUtils.searchText(this.browser, text, forward, caseSensitive, false)) {
            message = null;
        } else if (BrowserUtils.searchText(this.browser, text, forward, caseSensitive, true)) {
            message = forward ? "Search continued from top" : "Search continued from bottom";
        } else {
            Display.getCurrent().beep();
            message = "Search text not found";
        }
        StatusLineMessageManager statusManager = this.statusManager;
        if (statusManager != null) {
            statusManager.setMessage((IStatus)new StatusInfo(1, message));
        }
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        this.setDefaultFocus();
    }

    protected boolean setDefaultFocus() {
        BrowserAddressBar addressBar = this.addressBar;
        if (addressBar != null && addressBar.isVisible() && (this.session.getUrl().equals(ABOUT_BLANK_URI_STRING) || addressBar.isEdited())) {
            return addressBar.setFocus();
        }
        return this.setFocusToBrowser();
    }

    public boolean isBrowserFocusControl() {
        return UIAccess.isOkToUse((Control)this.browser) && this.browser.isFocusControl();
    }

    public boolean setFocusToBrowser() {
        return this.browser.setFocus();
    }

    public void setUrl(@Nullable String url) {
        Browser browser = this.browser;
        if (browser == null) {
            return;
        }
        if (url == null || ((String)url).isEmpty()) {
            url = ABOUT_BLANK_URI_STRING;
        }
        if (((String)url).startsWith("html:///")) {
            int id = this.session.putStatic(((String)url).substring(8, ((String)url).length()));
            url = STATIC_CONTENT_URL_PREFIX + id;
        }
        browser.setUrl((String)url, null, this.getHeaders());
    }

    public void setUrl(@Nullable URI url) {
        Browser browser = this.browser;
        if (browser == null) {
            return;
        }
        if (url == null) {
            url = ABOUT_BLANK_URI;
        }
        this.setUrl(url.toString());
    }

    public void refresh() {
        this.browser.refresh();
    }

    protected String @Nullable [] getHeaders() {
        return new String[]{"Cache-Control: no-cache"};
    }

    public String getCurrentTitle() {
        return this.session.getTitle();
    }

    public String getCurrentUrl() {
        return this.session.getUrl();
    }

    int getCurrentProgressTotal() {
        return this.progressTotal;
    }

    int getCurrentProgressWorked() {
        return this.progressWorked;
    }

    public void changed(ProgressEvent event) {
        if (event.total == 0) {
            this.progressTotal = 0;
            this.progressWorked = 0;
        } else {
            this.progressTotal = event.total;
            this.progressWorked = event.current;
        }
    }

    public void changing(LocationEvent event) {
        if (event.top) {
            this.session.setImageDescriptor(null);
        }
        if (event.location.startsWith(STATIC_CONTENT_URL_PREFIX)) {
            event.doit = false;
            try {
                String html = this.session.getStatic(Integer.parseInt(event.location.substring(11)));
                if (html != null) {
                    this.browser.setText(html);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (event.location.startsWith("about:")) {
            if (!event.location.equals(ABOUT_BLANK_URI_STRING)) {
                event.doit = false;
            }
            return;
        }
        if (event.location.startsWith("res:")) {
            event.doit = false;
            return;
        }
    }

    public void changed(LocationEvent event) {
        if (!event.top) {
            return;
        }
        String url = (String)ObjectUtils.nonNullElse((Object)event.location, (Object)"");
        this.session.setUrl(url);
        this.onPageChanged();
    }

    protected void onPageChanged() {
        BrowserAddressBar addressBar = this.addressBar;
        if (addressBar != null) {
            addressBar.onPageChanged();
        }
    }

    public void completed(ProgressEvent event) {
        this.progressTotal = 0;
        this.progressWorked = 0;
    }

    public void changed(TitleEvent event) {
        int idx;
        String title = (String)ObjectUtils.nonNullElse((Object)event.title, (Object)"");
        if (title.startsWith("http://") && (idx = title.lastIndexOf(47)) >= 0) {
            title = title.substring(idx + 1);
        }
        this.session.setTitle(title);
    }

    public void changed(StatusTextEvent event) {
        this.browserStatus = event.text != null && !event.text.isEmpty() ? new StatusInfo(0, event.text) : null;
        StatusLineMessageManager statusManager = this.statusManager;
        if (statusManager != null) {
            statusManager.setSelectionMessage(this.browserStatus);
        }
    }

    public void open(WindowEvent event) {
        PageBookBrowserPage page = (PageBookBrowserPage)((ManagedPageBookView)((Object)this.getView())).newPage((BrowserSession)new BrowserSession(), true);
        if (page != null) {
            event.browser = page.browser;
        }
    }

    public void close(WindowEvent event) {
        ((ManagedPageBookView)((Object)this.getView())).closePage((BrowserSession)this.session);
    }

    public @Nullable String getSelectedText() {
        return BrowserUtils.getSelectedText(this.browser);
    }

    protected class SearchBar
    implements DisposeListener {
        private ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        private ToolBar toolBar;
        private SearchContributionItem searchTextItem;
        private boolean searchCaseSensitive;

        public SearchBar(Composite parent) {
            this.toolBar = (ToolBar)ObjectUtils.nonNullAssert((Object)this.toolBarManager.createControl(parent));
            this.toolBar.setLayoutData((Object)new GridData(4, 4, true, false));
            this.toolBar.addDisposeListener((DisposeListener)this);
            this.toolBarManager.add((IContributionItem)new ContributionItem(){

                public void fill(ToolBar parent, int index) {
                    ToolItem item = new ToolItem(parent, 8);
                    item.setImage(SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/loctool/close"));
                    item.setHotImage(SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/loctoolh/close"));
                    item.setToolTipText("Close Search");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            SearchBar.this.hide();
                        }
                    });
                }
            });
            this.toolBarManager.add((IContributionItem)new Separator());
            this.searchTextItem = new SearchContributionItem("search.text", 0){

                @Override
                public void fill(ToolBar parent, int index) {
                    super.fill(parent, index);
                    this.getSearchText().getTextControl().addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            if (e.keyCode == 27 && e.doit) {
                                SearchBar.this.hide();
                                e.doit = false;
                                return;
                            }
                        }
                    });
                }

                @Override
                protected void search() {
                    PageBookBrowserPage.this.search(true);
                }
            };
            this.searchTextItem.setToolTip("Find Text");
            this.searchTextItem.setSizeControl(parent);
            this.toolBarManager.add((IContributionItem)this.searchTextItem);
            IPageSite serviceLocator = PageBookBrowserPage.this.getSite();
            ImageRegistry ecommonsImages = SharedUIResources.getImages();
            ContextHandlers pageHandlers = PageBookBrowserPage.this.getHandlers();
            this.toolBarManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, "Search.Next", "org.eclipse.ui.edit.findNext", null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/down"), null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctoolh/down"), null, null, SharedMessages.FindNextMatchAction_tooltip, 8, null, false), pageHandlers));
            this.toolBarManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)serviceLocator, "Search.Previous", "org.eclipse.ui.edit.findPrevious", null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/up"), null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctoolh/up"), null, null, SharedMessages.FindPreviousMatchAction_tooltip, 8, null, false), pageHandlers));
            this.toolBarManager.add((IContributionItem)new Separator());
            SimpleContributionItem caseItem = new SimpleContributionItem(new CommandContributionItemParameter(null, null, null, null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/images/loctool/casesensitive"), null, null, null, null, "Case Sensitive", 32, null, false)){

                @Override
                protected void execute() throws ExecutionException {
                    SearchBar.this.searchCaseSensitive = !SearchBar.this.searchCaseSensitive;
                    this.setChecked(SearchBar.this.searchCaseSensitive);
                }
            };
            caseItem.setChecked(this.searchCaseSensitive);
            this.toolBarManager.add((IContributionItem)caseItem);
            this.toolBarManager.update(true);
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.toolBar != null) {
                this.toolBarManager.dispose();
                this.toolBarManager = null;
                this.toolBar = null;
            }
        }

        public void show() {
            GridData gd = (GridData)this.toolBar.getLayoutData();
            gd.exclude = false;
            this.toolBar.getParent().layout(new Control[]{this.toolBar});
            this.searchTextItem.getSearchText().setFocus();
        }

        public void hide() {
            PageBookBrowserPage.this.setFocusToBrowser();
            GridData gd = (GridData)this.toolBar.getLayoutData();
            gd.exclude = true;
            this.toolBar.getParent().layout(new Control[]{this.toolBar});
        }

        public String getText() {
            return this.searchTextItem.getText();
        }

        public boolean isCaseSensitiveEnabled() {
            return this.searchCaseSensitive;
        }
    }
}

