/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt.util;

import org.eclipse.statet.ecommons.ui.swt.ImageUtils;
import org.eclipse.statet.ecommons.ui.swt.util.ColorUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

@NonNullByDefault
public class ArrowImageDataProvider
implements ImageDataProvider {
    public static final int DEFAULT_ARROW_SIZE = 5;
    private final int direction;
    private final Point imageSize;
    private final int arrowSize;
    private final RGB foregroundColor;

    public static RGB computeDefaultForegroundColor(RGB widgetForegroundColor, RGB widgetBackgroundColor) {
        return ColorUtils.blend(widgetForegroundColor, widgetBackgroundColor, 0.8f);
    }

    public static RGB computeDefaultForegroundColor(Color widgetForegroundColor, Color widgetBackgroundColor) {
        return ColorUtils.blend(widgetForegroundColor.getRGB(), widgetBackgroundColor.getRGB(), 0.8f);
    }

    public ArrowImageDataProvider(int direction, @Nullable Point imageSize, int arrowSize, RGB foregroundColor) {
        switch (direction) {
            case 128: 
            case 1024: 
            case 16384: 
            case 131072: {
                this.direction = direction;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction: " + direction);
            }
        }
        if (imageSize != null) {
            if (arrowSize == -1) {
                arrowSize = 5;
            }
        } else {
            if (arrowSize == -1) {
                arrowSize = 5;
            }
            int corr = arrowSize % 2 - 1;
            imageSize = switch (this.direction) {
                case 128, 1024 -> new Point(arrowSize * 3 + corr, arrowSize * 2);
                case 16384, 131072 -> new Point(arrowSize * 2, arrowSize * 3 + corr);
                default -> throw new RuntimeException();
            };
        }
        this.imageSize = imageSize;
        this.arrowSize = arrowSize;
        this.foregroundColor = (RGB)ObjectUtils.nonNullAssert((Object)foregroundColor);
    }

    public ArrowImageDataProvider(int direction, RGB foregroundColor) {
        this(direction, null, -1, foregroundColor);
    }

    public RGB getForegroundColor() {
        return this.foregroundColor;
    }

    public ImageData getImageData(int zoom) {
        int arrowX;
        int arrowHeight;
        int arrowWidth;
        ImageData imageData = ImageUtils.newDefaultTransparentImageData(this.imageSize, zoom);
        int arrowSize = ImageUtils.scaleLength(this.arrowSize, zoom);
        int arrowY = switch (this.direction) {
            case 128 -> {
                arrowWidth = arrowSize * 2 - 1;
                arrowHeight = arrowSize;
                arrowX = (imageData.width - arrowWidth) / 2;
                yield (imageData.height - arrowHeight) / 2;
            }
            case 1024 -> {
                arrowWidth = arrowSize * 2 - 1;
                arrowHeight = arrowSize;
                arrowX = (imageData.width - arrowWidth) / 2;
                yield (imageData.height - arrowHeight) / 2 + 1;
            }
            case 16384 -> {
                arrowWidth = arrowSize;
                arrowHeight = arrowSize * 2 - 1;
                arrowX = (imageData.width - arrowWidth) / 2;
                yield (imageData.height - arrowHeight) / 2;
            }
            case 131072 -> {
                arrowWidth = arrowSize;
                arrowHeight = arrowSize * 2 - 1;
                arrowX = (imageData.width - arrowWidth) / 2 + 1;
                yield (imageData.height - arrowHeight) / 2;
            }
            default -> throw new IllegalStateException();
        };
        int foreground = imageData.palette.getPixel(this.foregroundColor);
        switch (this.direction) {
            case 128: {
                int size1 = arrowWidth / 2 + arrowWidth % 2 - 1;
                int size2 = size1 * 2;
                int i = 0;
                while (i <= size1) {
                    int fix1 = arrowY + size1 - i;
                    int i2 = arrowX + i;
                    int last2 = arrowX + size2 - i;
                    imageData.setPixel(i2, fix1, foreground);
                    imageData.setAlpha(i2++, fix1, 191);
                    while (i2 < last2) {
                        imageData.setPixel(i2, fix1, foreground);
                        imageData.setAlpha(i2++, fix1, 255);
                    }
                    imageData.setPixel(last2, fix1, foreground);
                    imageData.setAlpha(last2, fix1, 191);
                    ++i;
                }
                break;
            }
            case 1024: {
                int size1 = arrowWidth / 2 + arrowWidth % 2 - 1;
                int size2 = size1 * 2;
                int i = 0;
                while (i <= size1) {
                    int fix1 = arrowY + i;
                    int i2 = arrowX + i;
                    int last2 = arrowX + size2 - i;
                    imageData.setPixel(i2, fix1, foreground);
                    imageData.setAlpha(i2++, fix1, 191);
                    while (i2 < last2) {
                        imageData.setPixel(i2, fix1, foreground);
                        imageData.setAlpha(i2++, fix1, 255);
                    }
                    imageData.setPixel(last2, fix1, foreground);
                    imageData.setAlpha(last2, fix1, 191);
                    ++i;
                }
                break;
            }
            case 16384: {
                int size1 = arrowHeight / 2 + arrowHeight % 2 - 1;
                int size2 = size1 * 2;
                int i = 0;
                while (i <= size1) {
                    int fix1 = arrowX + size1 - i;
                    int i2 = arrowY + i;
                    int last2 = arrowY + size2 - i;
                    imageData.setPixel(fix1, i2, foreground);
                    imageData.setAlpha(fix1, i2++, 191);
                    while (i2 < last2) {
                        imageData.setPixel(fix1, i2, foreground);
                        imageData.setAlpha(fix1, i2++, 255);
                    }
                    imageData.setPixel(fix1, last2, foreground);
                    imageData.setAlpha(fix1, last2, 191);
                    ++i;
                }
                break;
            }
            case 131072: {
                int size1 = arrowHeight / 2 + arrowHeight % 2 - 1;
                int size2 = size1 * 2;
                int i = 0;
                while (i <= size1) {
                    int fix1 = arrowX + i;
                    int i2 = arrowY + i;
                    int last2 = arrowY + size2 - i;
                    imageData.setPixel(fix1, i2, foreground);
                    imageData.setAlpha(fix1, i2++, 191);
                    while (i2 < last2) {
                        imageData.setPixel(fix1, i2, foreground);
                        imageData.setAlpha(fix1, i2++, 255);
                    }
                    imageData.setPixel(fix1, last2, foreground);
                    imageData.setAlpha(fix1, last2, 191);
                    ++i;
                }
                break;
            }
        }
        return imageData;
    }

    public int hashCode() {
        int h = 41269426 + this.direction;
        h = 31 * h + this.imageSize.hashCode();
        h = 31 * h + this.arrowSize;
        h = 31 * h + this.foregroundColor.hashCode();
        return h;
    }

    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                if (this == obj) break block2;
                if (!(obj instanceof ArrowImageDataProvider)) break block3;
                ArrowImageDataProvider other = (ArrowImageDataProvider)obj;
                if (this.direction == other.direction && this.imageSize.equals((Object)other.imageSize) && this.arrowSize == other.arrowSize && this.foregroundColor.equals((Object)other.foregroundColor)) break block2;
            }
            return false;
        }
        return true;
    }
}

