/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.statet.ecommons.ui.util.InputHistory;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class InputHistoryController<E> {
    private final IDialogSettings settings;
    private final String settingsHistoryKey;
    private final InputHistory<@NonNull E> history;
    private boolean isLoading;

    public InputHistoryController(IDialogSettings settings, String settingsHistoryKey, int maxLength) {
        this.settings = settings;
        this.settingsHistoryKey = settingsHistoryKey;
        this.history = this.createList(maxLength);
        this.load();
        this.history.addListChangeListener(event -> {
            if (!this.isLoading) {
                this.save();
            }
        });
    }

    public InputHistoryController(IDialogSettings settings, String settingsHistoryKey) {
        this(settings, settingsHistoryKey, 25);
    }

    protected InputHistory<@NonNull E> createList(int maxLength) {
        return new InputHistory(maxLength);
    }

    public InputHistory<E> getList() {
        return this.history;
    }

    protected void load() {
        this.isLoading = true;
        try {
            Object elements;
            IDialogSettings settings = this.settings;
            String[] serialized = settings.getArray(this.settingsHistoryKey);
            if (serialized != null) {
                elements = new ArrayList(serialized.length);
                int i = 0;
                while (i < serialized.length) {
                    @Nullable E element = this.createElement(serialized[i]);
                    if (element != null && !elements.contains(element)) {
                        elements.add(element);
                    }
                    ++i;
                }
            } else {
                elements = ImCollections.emptyList();
            }
            this.history.clear();
            this.history.addAll((Collection)elements);
        }
        finally {
            this.isLoading = false;
        }
    }

    protected void save() {
        IDialogSettings settings = this.settings;
        String[] serialized = new String[this.history.size()];
        int i = 0;
        while (i < serialized.length) {
            serialized[i] = this.serialize(this.history.get(i));
            ++i;
        }
        settings.put(this.settingsHistoryKey, serialized);
    }

    protected abstract @Nullable E createElement(String var1);

    protected abstract String serialize(@NonNull E var1);

    public static class ForString
    extends InputHistoryController<String> {
        public ForString(IDialogSettings settings, String settingsHistoryKey, int maxLength) {
            super(settings, settingsHistoryKey, maxLength);
        }

        public ForString(IDialogSettings settings, String settingsHistoryKey) {
            super(settings, settingsHistoryKey);
        }

        @Override
        protected @Nullable String createElement(String serialized) {
            return serialized;
        }

        @Override
        protected String serialize(String element) {
            return element;
        }
    }
}

