/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

@NonNullByDefault
public class LayoutUtils {
    private static final String WS = ((String)ObjectUtils.nonNullElse((Object)Platform.getWS(), (Object)"")).intern();
    private static @Nullable DialogValues gDialogValues;

    private static DialogValues getDialogValues() {
        if (gDialogValues == null) {
            JFaceResources.getFontRegistry().addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("org.eclipse.jface.dialogfont".equals(event.getProperty())) {
                        UIAccess.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                gDialogValues = new DialogValues();
                            }
                        });
                    }
                }
            });
            gDialogValues = new DialogValues();
        }
        return gDialogValues;
    }

    public static int defaultHMargin() {
        return LayoutUtils.getDialogValues().defaultHMargin;
    }

    public static int defaultVMargin() {
        return LayoutUtils.getDialogValues().defaultVMargin;
    }

    public static Point defaultSpacing() {
        return new Point(LayoutUtils.getDialogValues().defaultHSpacing, LayoutUtils.getDialogValues().defaultVSpacing);
    }

    public static int defaultHSpacing() {
        return LayoutUtils.getDialogValues().defaultHSpacing;
    }

    public static int defaultVSpacing() {
        return LayoutUtils.getDialogValues().defaultVSpacing;
    }

    public static int defaultIndent() {
        return LayoutUtils.getDialogValues().defaultIndent;
    }

    public static int defaultSmallIndent() {
        return LayoutUtils.getDialogValues().defaultSmallIndent;
    }

    public static int hintWidth(Button button) {
        button.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static GridData hintWidth(GridData gd, Button button) {
        gd.widthHint = LayoutUtils.hintWidth(button);
        return gd;
    }

    public static int hintWidth(Text text, int numChars) {
        return LayoutUtils.hintWidth(text, "org.eclipse.jface.dialogfont", numChars);
    }

    public static GridData hintWidth(GridData gd, Text text, int numChars) {
        gd.widthHint = LayoutUtils.hintWidth(text, "org.eclipse.jface.dialogfont", numChars);
        return gd;
    }

    public static int hintWidth(Text text, String symbolicName, int numChars) {
        if (symbolicName != null) {
            text.setFont(JFaceResources.getFontRegistry().get(symbolicName));
        }
        if (numChars == -1) {
            return LayoutUtils.getDialogValues().defaultEntryFieldWidth;
        }
        PixelConverter converter = new PixelConverter((Control)text);
        int widthHint = converter.convertWidthInCharsToPixels(numChars);
        return widthHint;
    }

    public static int hintWidth(StyledText text, String symbolicName, int numChars) {
        if (symbolicName != null) {
            text.setFont(JFaceResources.getFontRegistry().get(symbolicName));
        }
        if (numChars == -1) {
            return LayoutUtils.getDialogValues().defaultEntryFieldWidth;
        }
        PixelConverter converter = new PixelConverter((Control)text);
        int widthHint = converter.convertWidthInCharsToPixels(numChars);
        return widthHint;
    }

    public static int hintWidth(Combo combo, int numChars) {
        return LayoutUtils.hintWidth(combo, "org.eclipse.jface.dialogfont", numChars);
    }

    public static int hintWidth(Combo combo, String fontName, int numChars) {
        combo.setFont(JFaceResources.getFontRegistry().get(fontName));
        if (numChars == -1) {
            return LayoutUtils.getDialogValues().defaultEntryFieldWidth;
        }
        PixelConverter converter = new PixelConverter((Control)combo);
        int widthHint = converter.convertWidthInCharsToPixels(numChars + 1);
        Rectangle trim = combo.computeTrim(0, 0, widthHint, 0);
        if (trim.width > widthHint) {
            widthHint = trim.width;
        } else if ((combo.getStyle() & 4) == 4) {
            Button button = new Button(combo.getParent(), 1028);
            widthHint += button.computeSize((int)-1, (int)-1).x + 2;
            button.dispose();
        }
        return widthHint;
    }

    public static GridData hintWidth(GridData gd, Combo combo, int numChars) {
        return LayoutUtils.hintWidth(gd, combo, "org.eclipse.jface.dialogfont", numChars);
    }

    public static GridData hintWidth(GridData gd, Combo combo, String fontName, int numChars) {
        gd.widthHint = LayoutUtils.hintWidth(combo, fontName, numChars);
        return gd;
    }

    public static int hintWidth(Combo combo, String[] items) {
        return LayoutUtils.hintWidth(combo, (Collection<String>)ImCollections.newList((Object[])items));
    }

    public static int hintWidth(Combo combo, Collection<String> items) {
        int max = 0;
        for (String s : items) {
            max = Math.max(max, s.length());
        }
        return LayoutUtils.hintWidth(combo, "org.eclipse.jface.dialogfont", max);
    }

    public static int hintWidth(Combo combo, List<?> input, ILabelProvider labelProvider) {
        combo.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        GC gc = new GC((Drawable)combo);
        int widthHint = 0;
        for (Object o : input) {
            String s = labelProvider.getText(o);
            if (s == null) continue;
            widthHint = Math.max(widthHint, gc.stringExtent((String)s).x);
        }
        gc.dispose();
        Rectangle trim = combo.computeTrim(0, 0, widthHint, 0);
        if (trim.width > widthHint) {
            widthHint = trim.width;
        }
        return widthHint;
    }

    public static int hintWidth(Table table, String fontName, boolean icon, int numChars) {
        if (fontName != null) {
            table.setFont(JFaceResources.getFontRegistry().get(fontName));
        }
        PixelConverter converter = new PixelConverter((Control)table);
        int width = converter.convertWidthInCharsToPixels(numChars);
        ScrollBar scrollBar = table.getVerticalBar();
        if (scrollBar != null) {
            width += scrollBar.getSize().x;
        }
        if ((table.getStyle() & 0x20) == 32) {
            width += 16 + converter.convertHorizontalDLUsToPixels(4) + converter.convertWidthInCharsToPixels(1);
        }
        if (icon) {
            width += 16 + converter.convertHorizontalDLUsToPixels(4);
        }
        return width;
    }

    public static int hintWidth(Table table, int numChars) {
        return LayoutUtils.hintWidth(table, "org.eclipse.jface.dialogfont", false, numChars);
    }

    public static int hintWidth(Table table, Collection<String> items) {
        int max = 0;
        for (String s : items) {
            max = Math.max(max, s.length());
        }
        return LayoutUtils.hintWidth(table, max);
    }

    public static int hintWidth(Table table, Object[] input, ILabelProvider labelProvider) {
        int max = 0;
        Object[] objectArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            String s = labelProvider.getText(o);
            if (s != null) {
                max = Math.max(max, s.length());
            }
            ++n2;
        }
        return LayoutUtils.hintWidth(table, max);
    }

    public static int hintColWidth(Table table, int numChars) {
        table.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        PixelConverter converter = new PixelConverter((Control)table);
        int width = converter.convertWidthInCharsToPixels(numChars);
        return width;
    }

    public static int hintWidth(Tree tree, String fontName, boolean icon, int numChars) {
        if (fontName != null) {
            tree.setFont(JFaceResources.getFontRegistry().get(fontName));
        }
        PixelConverter converter = new PixelConverter((Control)tree);
        int width = converter.convertWidthInCharsToPixels(numChars);
        ScrollBar scrollBar = tree.getVerticalBar();
        if (scrollBar != null) {
            width += scrollBar.getSize().x;
        }
        if ((tree.getStyle() & 0x20) == 32) {
            width += 16 + converter.convertHorizontalDLUsToPixels(4) + converter.convertWidthInCharsToPixels(1);
        }
        if (icon) {
            width += 16 + converter.convertHorizontalDLUsToPixels(4);
        }
        return width;
    }

    public static int hintWidth(Tree tree, int numChars) {
        return LayoutUtils.hintWidth(tree, "org.eclipse.jface.dialogfont", false, numChars);
    }

    public static int hintWidth(Tree tree, Collection<String> items) {
        int max = 0;
        for (String s : items) {
            max = Math.max(max, s.length());
        }
        return LayoutUtils.hintWidth(tree, max);
    }

    public static int hintHeight(org.eclipse.swt.widgets.List control, int rows) {
        control.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        return control.getItemHeight() * rows;
    }

    public static int hintHeight(Table control, int rows, boolean withScrollbar) {
        control.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        int height = control.getHeaderHeight();
        height += control.getItemHeight() * rows;
        if (!withScrollbar && WS == "win32") {
            ScrollBar hBar = control.getHorizontalBar();
            if (hBar != null) {
                height -= hBar.getSize().y;
            }
        } else if (WS == "win32") {
            height += control.getBorderWidth() * 2;
        }
        return height;
    }

    public static int hintHeight(Table control, int rows) {
        return LayoutUtils.hintHeight(control, rows, true);
    }

    public static int hintHeight(Tree control, int rows, boolean withScrollbar) {
        control.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
        int height = control.getHeaderHeight();
        height += control.getItemHeight() * rows;
        if (!withScrollbar && WS == "win32") {
            ScrollBar hBar = control.getHorizontalBar();
            if (hBar != null) {
                height -= hBar.getSize().y;
            }
        } else if (WS == "win32") {
            height += control.getBorderWidth() * 2;
        }
        return height;
    }

    public static int hintHeight(Tree control, int rows) {
        return LayoutUtils.hintHeight(control, rows, true);
    }

    public static int hintHeight(Label control, int lines) {
        PixelConverter converter = new PixelConverter((Control)control);
        return converter.convertHeightInCharsToPixels(lines);
    }

    public static int hintHeight(StyledText control, int lines) {
        int height = control.getLineHeight() * lines;
        ScrollBar hBar = control.getHorizontalBar();
        if (hBar != null) {
            height += hBar.getSize().y;
        }
        return height;
    }

    public static GridData createGD(Button button) {
        GridData gd = new GridData(4, 4, false, false);
        gd.widthHint = LayoutUtils.hintWidth(button);
        return gd;
    }

    public static GridLayout applyDialogDefaults(GridLayout layout) {
        DialogValues dialogValues = LayoutUtils.getDialogValues();
        layout.marginWidth = dialogValues.defaultHMargin;
        layout.marginHeight = dialogValues.defaultVMargin;
        layout.horizontalSpacing = dialogValues.defaultHSpacing;
        layout.verticalSpacing = dialogValues.defaultVSpacing;
        return layout;
    }

    public static GridLayout newDialogGrid(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.numColumns = numColumns;
        LayoutUtils.applyDialogDefaults(layout);
        return layout;
    }

    public static GridLayout applyCompositeDefaults(GridLayout layout) {
        DialogValues dialogValues = LayoutUtils.getDialogValues();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = dialogValues.defaultHSpacing;
        layout.verticalSpacing = dialogValues.defaultVSpacing;
        return layout;
    }

    public static GridLayout newCompositeGrid() {
        GridLayout layout = new GridLayout();
        LayoutUtils.applyCompositeDefaults(layout);
        return layout;
    }

    public static GridLayout newCompositeGrid(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        LayoutUtils.applyCompositeDefaults(layout);
        return layout;
    }

    public static GridLayout newCompositeGrid(int numColumns, boolean equalWidth) {
        GridLayout layout = new GridLayout(numColumns, equalWidth);
        LayoutUtils.applyCompositeDefaults(layout);
        return layout;
    }

    public static GridLayout applyGroupDefaults(GridLayout layout) {
        DialogValues dialogValues = LayoutUtils.getDialogValues();
        layout.marginWidth = dialogValues.defaultHSpacing;
        layout.marginHeight = dialogValues.defaultVSpacing;
        layout.horizontalSpacing = dialogValues.defaultHSpacing;
        layout.verticalSpacing = dialogValues.defaultVSpacing;
        return layout;
    }

    public static GridLayout newGroupGrid(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        LayoutUtils.applyGroupDefaults(layout);
        return layout;
    }

    public static GridLayout newGroupGrid(int numColumns, boolean equalWidth) {
        GridLayout layout = new GridLayout(numColumns, equalWidth);
        LayoutUtils.applyGroupDefaults(layout);
        return layout;
    }

    public static GridLayout applyContentDefaults(GridLayout layout) {
        DialogValues dialogValues = LayoutUtils.getDialogValues();
        layout.marginWidth = dialogValues.defaultHSpacing;
        layout.marginHeight = dialogValues.defaultVSpacing;
        layout.horizontalSpacing = dialogValues.defaultHSpacing;
        layout.verticalSpacing = dialogValues.defaultVSpacing;
        return layout;
    }

    public static GridLayout newContentGrid() {
        GridLayout layout = new GridLayout();
        LayoutUtils.applyContentDefaults(layout);
        return layout;
    }

    public static GridLayout newContentGrid(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        LayoutUtils.applyContentDefaults(layout);
        return layout;
    }

    public static GridLayout newContentGrid(int numColumns, boolean equalWidth) {
        GridLayout layout = new GridLayout(numColumns, equalWidth);
        LayoutUtils.applyContentDefaults(layout);
        return layout;
    }

    public static GridLayout applyTabDefaults(GridLayout layout) {
        DialogValues dialogValues = LayoutUtils.getDialogValues();
        layout.marginWidth = dialogValues.defaultHSpacing;
        layout.marginHeight = dialogValues.defaultVSpacing;
        layout.horizontalSpacing = dialogValues.defaultHSpacing;
        layout.verticalSpacing = dialogValues.defaultVSpacing;
        return layout;
    }

    public static FillLayout applyTabDefaults(FillLayout layout) {
        DialogValues dialogValues = LayoutUtils.getDialogValues();
        layout.marginWidth = dialogValues.defaultHSpacing;
        layout.marginHeight = dialogValues.defaultVSpacing;
        layout.spacing = layout.type == 256 ? dialogValues.defaultHSpacing : dialogValues.defaultVSpacing;
        return layout;
    }

    public static GridLayout newTabGrid() {
        GridLayout layout = new GridLayout();
        LayoutUtils.applyTabDefaults(layout);
        return layout;
    }

    public static GridLayout newTabGrid(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        LayoutUtils.applyTabDefaults(layout);
        return layout;
    }

    public static GridLayout newTabGrid(int numColumns, boolean equalWidth) {
        GridLayout layout = new GridLayout(numColumns, equalWidth);
        LayoutUtils.applyTabDefaults(layout);
        return layout;
    }

    public static GridLayout applySashDefaults(GridLayout layout) {
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    public static GridLayout newSashGrid(int numColumns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        LayoutUtils.applySashDefaults(layout);
        return layout;
    }

    public static GridLayout newSashGrid() {
        GridLayout layout = new GridLayout();
        LayoutUtils.applySashDefaults(layout);
        return layout;
    }

    public static void addGDDummy(Composite composite) {
        LayoutUtils.addGDDummy(composite, false);
    }

    public static void addGDDummy(Composite composite, boolean grab) {
        Label dummy = new Label(composite, 0);
        dummy.setVisible(false);
        dummy.setLayoutData((Object)new GridData(16384, 128, grab, false));
    }

    public static void addGDDummy(Composite composite, boolean grab, int span) {
        Label dummy = new Label(composite, 0);
        dummy.setVisible(false);
        dummy.setLayoutData((Object)new GridData(16384, 128, grab, false, span, 1));
    }

    public static void addSmallFiller(Composite composite, boolean grab) {
        Label filler = new Label(composite, 0);
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            GridData gd = new GridData(4, 4, false, grab);
            gd.horizontalSpan = ((GridLayout)layout).numColumns;
            gd.heightHint = LayoutUtils.defaultVSpacing() / 2;
            filler.setLayoutData((Object)gd);
        }
    }

    private LayoutUtils() {
    }

    private static class DialogValues {
        int defaultEntryFieldWidth;
        int defaultHMargin;
        int defaultVMargin;
        int defaultHSpacing;
        int defaultVSpacing;
        int defaultIndent;
        int defaultSmallIndent;

        public DialogValues() {
            GC gc = new GC((Drawable)Display.getCurrent());
            try {
                gc.setFont(JFaceResources.getDialogFont());
                FontMetrics fontMetrics = gc.getFontMetrics();
                this.defaultHMargin = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)7);
                this.defaultVMargin = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)7);
                this.defaultHSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
                this.defaultVSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)4);
                this.defaultEntryFieldWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)200);
                this.defaultIndent = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)21);
                this.defaultSmallIndent = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)7);
            }
            finally {
                gc.dispose();
            }
        }
    }
}

