/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.Breadcrumb;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public abstract class AbstractBreadcrumb
implements Breadcrumb {
    private static final String ACTIVE_TAB_BG_END = "org.eclipse.ui.workbench.ACTIVE_TAB_BG_END";
    private BreadcrumbViewer breadcrumbViewer;
    private boolean hasFocus;
    private boolean isActive;
    private Composite composite;
    private Listener displayFocusListener;
    private @Nullable Listener displayKeyListener;
    private IPropertyChangeListener propertyChangeListener;
    private int breadcrumbServiceState;
    private ServiceLocator breadcrumbServices;

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.breadcrumbViewer;
    }

    @Override
    public void setInput(@Nullable Object element) {
        if (element == null) {
            return;
        }
        if (this.breadcrumbViewer.isDropDownOpen()) {
            return;
        }
        Object input = this.breadcrumbViewer.getInput();
        if (element == input) {
            this.breadcrumbViewer.refresh(true);
            return;
        }
        this.breadcrumbViewer.setInput(element);
    }

    @Override
    public void activate() {
        this.breadcrumbViewer.setSelection((ISelection)new StructuredSelection(this.breadcrumbViewer.getInput()));
        this.breadcrumbViewer.setFocus();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public Control createContent(Composite parent) {
        assert (this.composite == null);
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = LayoutUtils.newSashGrid();
        this.composite.setLayout((Layout)gridLayout);
        this.displayFocusListener = new Listener(){

            public void handleEvent(Event event) {
                if (AbstractBreadcrumb.this.isBreadcrumbEvent(event)) {
                    if (AbstractBreadcrumb.this.hasFocus) {
                        return;
                    }
                    AbstractBreadcrumb.this.isActive = true;
                    AbstractBreadcrumb.this.focusGained();
                } else {
                    if (!AbstractBreadcrumb.this.isActive) {
                        return;
                    }
                    if (AbstractBreadcrumb.this.hasInputFocus()) {
                        AbstractBreadcrumb.this.isActive = false;
                    }
                    if (!AbstractBreadcrumb.this.hasFocus) {
                        return;
                    }
                    AbstractBreadcrumb.this.focusLost();
                }
            }
        };
        Display.getCurrent().addFilter(15, this.displayFocusListener);
        this.breadcrumbViewer = this.createViewer(this.composite);
        this.breadcrumbViewer.getControl().setBackground(Display.getDefault().getSystemColor(1));
        this.breadcrumbViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AbstractBreadcrumb.this.doRevealOrOpen(event.getSelection());
            }
        });
        this.breadcrumbViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element == null) {
                    return;
                }
                if (AbstractBreadcrumb.this.doRevealOrOpen(event.getSelection())) {
                    return;
                }
            }
        });
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (AbstractBreadcrumb.ACTIVE_TAB_BG_END.equals(event.getProperty()) && AbstractBreadcrumb.this.composite.isFocusControl()) {
                    AbstractBreadcrumb.this.composite.setBackground(JFaceResources.getColorRegistry().get(AbstractBreadcrumb.ACTIVE_TAB_BG_END));
                }
            }
        };
        JFaceResources.getColorRegistry().addListener(this.propertyChangeListener);
        return this.composite;
    }

    @Override
    public void dispose() {
        if (this.isServiceLocatorReady(false)) {
            this.breadcrumbServiceState = -1;
            this.breadcrumbServices.dispose();
            this.breadcrumbServices = null;
        }
        if (this.propertyChangeListener != null) {
            JFaceResources.getColorRegistry().removeListener(this.propertyChangeListener);
        }
        if (this.displayFocusListener != null) {
            Display.getDefault().removeFilter(15, this.displayFocusListener);
        }
        this.deinstallDisplayListeners();
    }

    private boolean doRevealOrOpen(ISelection selection) {
        if (this.doReveal(selection)) {
            this.setFocusToInput();
            return true;
        }
        if (this.doOpen(selection)) {
            this.isActive = false;
            this.focusLost();
            this.updateInput();
            return true;
        }
        return false;
    }

    private boolean doOpen(ISelection selection) {
        Object selectedElement;
        if (selection instanceof StructuredSelection && (selectedElement = ((StructuredSelection)selection).getFirstElement()) != null) {
            return this.open(selectedElement);
        }
        return false;
    }

    private boolean doReveal(ISelection selection) {
        Object selectedElement;
        if (selection instanceof StructuredSelection && (selectedElement = ((StructuredSelection)selection).getFirstElement()) != null) {
            return this.reveal(selectedElement);
        }
        return false;
    }

    private void focusGained() {
        if (this.composite.isDisposed()) {
            return;
        }
        if (this.hasFocus) {
            this.focusLost();
        }
        this.composite.setBackground(JFaceResources.getColorRegistry().get(ACTIVE_TAB_BG_END));
        this.hasFocus = true;
        this.installDisplayListeners();
        this.activateBreadcrumb();
        this.updateActions();
    }

    private void focusLost() {
        if (!this.hasFocus || this.composite.isDisposed()) {
            return;
        }
        this.composite.setBackground(null);
        this.hasFocus = false;
        this.deinstallDisplayListeners();
        this.deactivateBreadcrumb();
        this.updateActions();
    }

    private void installDisplayListeners() {
        Listener listener;
        this.deinstallDisplayListeners();
        this.displayKeyListener = listener = new Listener(){

            public void handleEvent(Event event) {
                if (!event.doit) {
                    return;
                }
                if (event.keyCode == 27 && AbstractBreadcrumb.this.isBreadcrumbEvent(event)) {
                    AbstractBreadcrumb.this.setFocusToInput();
                }
            }
        };
        Display.getDefault().addFilter(1, listener);
    }

    private void deinstallDisplayListeners() {
        Listener listener = this.displayKeyListener;
        if (listener != null) {
            this.displayKeyListener = null;
            Display.getDefault().removeFilter(1, listener);
        }
    }

    private boolean isBreadcrumbEvent(Event event) {
        if (this.breadcrumbViewer == null) {
            return false;
        }
        Widget item = event.widget;
        if (!(item instanceof Control)) {
            return false;
        }
        Shell dropDownShell = this.breadcrumbViewer.getDropDownShell();
        if (dropDownShell != null && this.isChild((Control)item, (Control)dropDownShell)) {
            return true;
        }
        return this.isChild((Control)item, this.breadcrumbViewer.getControl());
    }

    private boolean isChild(@Nullable Control child, Control parent) {
        if (child == null || child.isDisposed()) {
            return false;
        }
        if (child == parent) {
            return true;
        }
        return this.isChild((Control)child.getParent(), parent);
    }

    private boolean isServiceLocatorReady(boolean init) {
        if (this.breadcrumbServiceState == 0) {
            this.breadcrumbServiceState = -1;
            IServiceLocator pageServices = this.getParentServiceLocator();
            IServiceLocatorCreator serviceCreator = (IServiceLocatorCreator)pageServices.getService(IServiceLocatorCreator.class);
            this.breadcrumbServices = (ServiceLocator)serviceCreator.createServiceLocator(pageServices, null, new IDisposable(){

                public void dispose() {
                    AbstractBreadcrumb.this.breadcrumbServiceState = -1;
                    AbstractBreadcrumb.this.breadcrumbServices = null;
                }
            });
            this.breadcrumbServiceState = 1;
            this.initActions((IServiceLocator)this.breadcrumbServices);
        }
        return this.breadcrumbServiceState > 0;
    }

    protected void initActions(IServiceLocator services) {
        IContextService contextService = (IContextService)services.getService(IContextService.class);
        contextService.activateContext("org.eclipse.jdt.ui.breadcrumbEditorScope");
    }

    protected abstract BreadcrumbViewer createViewer(Composite var1);

    protected abstract IServiceLocator getParentServiceLocator();

    protected abstract boolean hasInputFocus();

    protected abstract void setFocusToInput();

    protected void updateActions() {
    }

    protected void activateBreadcrumb() {
        if (this.isServiceLocatorReady(true)) {
            this.breadcrumbServices.activate();
        }
    }

    protected void deactivateBreadcrumb() {
        if (this.isServiceLocatorReady(true)) {
            this.breadcrumbServices.deactivate();
        }
    }

    protected void updateInput() {
    }

    protected abstract boolean reveal(Object var1);

    protected abstract boolean open(Object var1);
}

