/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.ui.sourceediting.actions;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.statet.ltk.ui.EditorUtils;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.actions.ToggleCommentHandler;
import org.eclipse.statet.redocs.r.ui.sourceediting.RweaveEditor;

public abstract class RweaveToggleCommentHandler
extends ToggleCommentHandler {
    public RweaveToggleCommentHandler(SourceEditor1 editor) {
        super(editor);
        assert (editor instanceof RweaveEditor);
    }

    protected void run(AbstractDocument document, ITextSelection selection, int operationCode) {
        try {
            if (this.isMixed((IDocument)document, selection)) {
                IRegion block = EditorUtils.getTextBlockFromSelection((IDocument)document, (int)selection.getOffset(), (int)selection.getLength());
                switch (operationCode) {
                    case 11: {
                        this.doPrefixPrimary(document, block);
                        return;
                    }
                    case 12: {
                        this.doStripPrefix(document, block);
                        return;
                    }
                }
                throw new IllegalArgumentException("operationCode= " + operationCode);
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            this.log((Exception)e);
        }
        this.doRunOperation(operationCode);
    }

    protected boolean isMixed(IDocument document, ITextSelection selection) throws BadLocationException, BadPartitioningException {
        IRegion block = EditorUtils.getTextBlockFromSelection((IDocument)document, (int)selection.getOffset(), (int)selection.getLength());
        IRegion rContent = ((RweaveEditor)this.getEditor()).getDocumentContentInfo().getRChunkContentRegion(document, block.getOffset());
        return rContent == null || block.getOffset() < rContent.getOffset() || block.getOffset() + block.getLength() > rContent.getOffset() + rContent.getLength();
    }

    protected abstract void doPrefixPrimary(AbstractDocument var1, IRegion var2) throws BadLocationException, BadPartitioningException;
}

