/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.core.data;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.core.data.ColumnAccessor;
import org.eclipse.statet.ecommons.waltable.core.data.DataProvider;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ListDataProvider<T>
implements DataProvider {
    protected final List<T> list;
    protected final ColumnAccessor<T> columnAccessor;

    public ListDataProvider(List<T> list, ColumnAccessor<T> columnAccessor) {
        this.list = list;
        this.columnAccessor = columnAccessor;
    }

    public List<T> getList() {
        return this.list;
    }

    @Override
    public long getColumnCount() {
        return this.columnAccessor.getColumnCount();
    }

    @Override
    public long getRowCount() {
        return this.list.size();
    }

    public T getRowObject(long rowIndex) {
        if (rowIndex >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.get((int)rowIndex);
    }

    public long indexOfRowObject(T rowObject) {
        return this.list.indexOf(rowObject);
    }

    @Override
    public @Nullable Object getDataValue(long columnIndex, long rowIndex, int flags, @Nullable IProgressMonitor monitor) {
        T rowObject = this.getRowObject(rowIndex);
        return this.columnAccessor.getDataValue(rowObject, columnIndex);
    }

    @Override
    public void setDataValue(long columnIndex, long rowIndex, @Nullable Object newValue) {
        T rowObject = this.getRowObject(rowIndex);
        this.columnAccessor.setDataValue(rowObject, columnIndex, newValue);
    }
}

