/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.core;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.events.DimPositionsVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DimSelectionEvent
extends DimPositionsVisualChangeEvent
implements SelectionEvent {
    private final SelectionLayer selectionLayer;
    private final long positionToReveal;

    public DimSelectionEvent(SelectionLayer selectionLayer, Orientation orientation, long position, boolean revealPosition) {
        this(selectionLayer, orientation, (List<LRange>)new LRangeList(position), revealPosition ? position : Long.MIN_VALUE);
    }

    public DimSelectionEvent(SelectionLayer selectionLayer, Orientation orientation, List<LRange> positions, long positionToReveal) {
        super((LayerDim)selectionLayer.getDim(orientation), positions);
        this.selectionLayer = selectionLayer;
        this.positionToReveal = positionToReveal;
    }

    protected DimSelectionEvent(SelectionLayer selectionLayer, LayerDim layerDim, List<LRange> positions, long positionToReveal) {
        super(layerDim, positions);
        this.selectionLayer = selectionLayer;
        this.positionToReveal = positionToReveal;
    }

    @Override
    protected @Nullable DimPositionsVisualChangeEvent toLayer(LayerDim targetLayerDim, List<LRange> positions) {
        long positionToReveal = this.positionToReveal != Long.MIN_VALUE ? targetLayerDim.underlyingToLocalPosition(this.getLayerDim(), this.positionToReveal) : Long.MIN_VALUE;
        return new DimSelectionEvent(this.selectionLayer, targetLayerDim, positions, positionToReveal);
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public long getPositionToReveal() {
        return this.positionToReveal;
    }
}

