/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.commonmark.ui;

import java.util.Locale;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.ParseHelper;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.MarkupCompletionExtension;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;

@NonNullByDefault
public class CommonmarkCompletionExtension
implements MarkupCompletionExtension {
    private final ParseHelper helper = new ParseHelper();

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MarkupCompletionExtension.CompletionType getLinkAnchorLabel(AssistInvocationContext context, WikitextMarkupLanguage markupLanguage) {
        try {
            int endOffset;
            IDocument document = context.getDocument();
            int startOffset = endOffset = context.getOffset();
            while (startOffset > 0) {
                char c;
                if (Character.isLetterOrDigit(c = document.getChar(--startOffset)) || c == '-' || c == '_' || c == ':' || c == '.') continue;
                if (c != '#' || startOffset <= 0 || document.getChar(startOffset - 1) == '\\') break;
                return new MarkupCompletionExtension.CompletionType(document.get(++startOffset, endOffset - startOffset));
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MarkupCompletionExtension.CompletionType getLinkRefLabel(AssistInvocationContext context, WikitextMarkupLanguage markupLanguage) {
        try {
            int endOffset;
            IDocument document = context.getDocument();
            int startOffset = endOffset = context.getInvocationOffset();
            int lookupBound = Math.max(startOffset - 1000, 0);
            while (startOffset > lookupBound) {
                char c;
                if ((c = document.getChar(--startOffset)) == '[' && !this.isEscaped(document, startOffset)) {
                    ++startOffset;
                    startOffset = this.forwardBlank(document, startOffset, endOffset);
                    String sourcePrefix = document.get(startOffset, endOffset - startOffset);
                    String lookupPrefix = this.normalizeLabel(sourcePrefix);
                    return new MarkupCompletionExtension.CompletionType(sourcePrefix, lookupPrefix);
                }
                if (c == '\n' && c == '\r') break;
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private boolean isEscaped(IDocument document, int offset) throws BadLocationException {
        int count = 0;
        while (offset > 0) {
            if (document.getChar(--offset) != '\\') break;
            ++count;
        }
        return count % 2 == 1;
    }

    private int forwardBlank(IDocument document, int offset, int endOffset) throws BadLocationException {
        while (offset < endOffset) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') break;
            ++offset;
        }
        return offset;
    }

    private String normalizeLabel(String label) {
        if (label.isEmpty()) {
            return "";
        }
        if ((label = this.helper.collapseWhitespace(label)).isEmpty()) {
            return "";
        }
        return label.toLowerCase(Locale.ROOT);
    }
}

