/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.menu.vector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.AxisSettings;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.export.core.VectorExportSettingsDialog;
import org.eclipse.swtchart.export.menu.vector.AbstractInkscapeTemplate;
import org.eclipse.swtchart.export.menu.vector.IVectorDataExport;
import org.eclipse.swtchart.export.menu.vector.InkscapeBarChart;
import org.eclipse.swtchart.export.menu.vector.InkscapeLineChart;
import org.eclipse.swtchart.export.menu.vector.InkscapeScatterChart;
import org.eclipse.swtchart.export.menu.vector.Messages;
import org.eclipse.swtchart.extensions.barcharts.BarChart;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ChartType;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.linecharts.LineChart;
import org.eclipse.swtchart.extensions.scattercharts.ScatterChart;

public class SVGExportHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private static final String FILE_EXTENSION = "*.svg";
    private static final String NAME = MessageFormat.format(Messages.getString("SVG"), "*.svg");
    private static final String TITLE = Messages.getString("SAVE_AS_SVG");

    public String getName() {
        return NAME;
    }

    public Image getIcon() {
        return ResourceSupport.getImage((String)"figure.gif");
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(NAME);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION});
        fileDialog.setFileName(scrollableChart.getFileName());
        String fileName = fileDialog.open();
        if (fileName != null) {
            try {
                BaseChart baseChart = scrollableChart.getBaseChart();
                VectorExportSettingsDialog exportSettingsDialog = new VectorExportSettingsDialog(fileDialog.getParent(), baseChart);
                exportSettingsDialog.create();
                if (exportSettingsDialog.open() == 0) {
                    int indexAxisX = exportSettingsDialog.getIndexAxisSelectionX();
                    int indexAxisY = exportSettingsDialog.getIndexAxisSelectionY();
                    if (indexAxisX >= 0 && indexAxisY >= 0) {
                        try {
                            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(fileDialog.getParent());
                            monitorDialog.run(false, false, monitor -> {
                                try {
                                    try {
                                        Object secondaryAxisSettings;
                                        monitor.beginTask(Messages.getString("EXPORT_TO_SVG"), -1);
                                        IAxisSettings axisSettingsX = baseChart.getXAxisSettings(indexAxisX);
                                        IAxisScaleConverter axisScaleConverterX = null;
                                        if (axisSettingsX instanceof ISecondaryAxisSettings) {
                                            ISecondaryAxisSettings secondaryAxisSettings2 = (ISecondaryAxisSettings)axisSettingsX;
                                            axisScaleConverterX = secondaryAxisSettings2.getAxisScaleConverter();
                                        }
                                        IAxisSettings axisSettingsY = baseChart.getYAxisSettings(indexAxisY);
                                        IAxisScaleConverter axisScaleConverterY = null;
                                        if (axisSettingsY instanceof ISecondaryAxisSettings) {
                                            secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsY;
                                            axisScaleConverterY = secondaryAxisSettings.getAxisScaleConverter();
                                        }
                                        try {
                                            secondaryAxisSettings = null;
                                            Object var13_16 = null;
                                            try (PrintWriter printWriter = new PrintWriter(new File(fileName));){
                                                AxisSettings axisSettings = new AxisSettings();
                                                axisSettings.setIndexAxisX(indexAxisX);
                                                axisSettings.setIndexAxisY(indexAxisY);
                                                axisSettings.setAxisSettingsX(axisSettingsX);
                                                axisSettings.setAxisScaleConverterX(axisScaleConverterX);
                                                axisSettings.setAxisSettingsY(axisSettingsY);
                                                axisSettings.setAxisScaleConverterY(axisScaleConverterY);
                                                AbstractInkscapeTemplate vectorDataExport = null;
                                                if (scrollableChart instanceof LineChart) {
                                                    vectorDataExport = new InkscapeLineChart();
                                                } else if (scrollableChart instanceof BarChart) {
                                                    vectorDataExport = new InkscapeBarChart();
                                                } else if (scrollableChart instanceof ScatterChart) {
                                                    vectorDataExport = new InkscapeScatterChart();
                                                } else {
                                                    ChartType chartType = scrollableChart.getChartType();
                                                    switch (chartType) {
                                                        case LINE: 
                                                        case STEP: {
                                                            vectorDataExport = new InkscapeLineChart();
                                                            break;
                                                        }
                                                        case BAR: {
                                                            vectorDataExport = new InkscapeBarChart();
                                                            break;
                                                        }
                                                        case SCATTER: {
                                                            vectorDataExport = new InkscapeScatterChart();
                                                            break;
                                                        }
                                                        default: {
                                                            System.out.println("The chart type export is not supported yet: " + String.valueOf(chartType));
                                                        }
                                                    }
                                                }
                                                if (vectorDataExport != null) {
                                                    this.exportPlot(printWriter, vectorDataExport, scrollableChart, axisSettings);
                                                }
                                                MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)MESSAGE_OK);
                                            }
                                            catch (Throwable throwable) {
                                                if (secondaryAxisSettings == null) {
                                                    secondaryAxisSettings = throwable;
                                                } else if (secondaryAxisSettings != throwable) {
                                                    ((Throwable)secondaryAxisSettings).addSuppressed(throwable);
                                                }
                                                throw secondaryAxisSettings;
                                            }
                                        }
                                        catch (FileNotFoundException e) {
                                            MessageDialog.openError((Shell)shell, (String)TITLE, (String)MESSAGE_ERROR);
                                            e.printStackTrace();
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        monitor.done();
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            });
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                exportSettingsDialog.reset();
                scrollableChart.updateLegend();
            }
            catch (InvocationTargetException e) {
                MessageDialog.openInformation((Shell)shell, (String)TITLE, (String)"DATA_EXPORT_ERROR");
                e.getCause().printStackTrace();
            }
        }
    }

    private void exportPlot(PrintWriter printWriter, IVectorDataExport vectorDataExport, ScrollableChart scrollableChart, AxisSettings axisSettings) throws Exception {
        String content = vectorDataExport.generate(scrollableChart, axisSettings);
        printWriter.print(content);
    }
}

