/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.internal.marker.EmbeddedLegend;
import org.eclipse.swtchart.extensions.internal.support.PositionValidator;

public class InChartLegendUI
extends Composite {
    private ScrollableChart scrollableChart;
    private EmbeddedLegend embeddedLegend;
    private boolean capturePosition = false;
    private Text textX;
    private Text textY;
    private List<Control> controls = new ArrayList<Control>();
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public InChartLegendUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update() {
        super.update();
        this.updateControls();
        this.updateLegendPosition(true);
    }

    public void setScrollableChart(ScrollableChart scrollableChart) {
        this.scrollableChart = scrollableChart;
        this.createEmbeddedLegend();
    }

    public boolean toggleLegend() {
        boolean draw = false;
        if (this.embeddedLegend != null) {
            draw = !this.embeddedLegend.isDraw();
            this.embeddedLegend.setDraw(draw);
            if (this.scrollableChart != null) {
                this.scrollableChart.redraw();
            }
            this.updateControls();
        }
        return draw;
    }

    private void createControl() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.setLayout((Layout)gridLayout);
        this.createToolbarInChartLegend(this);
        this.initialize();
    }

    private void initialize() {
    }

    private void createToolbarInChartLegend(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.add((Control)this.createButtonMove(composite, "arrowLeft.svg", Messages.getString("MOVE_LEGEND_LEFT")));
        this.add((Control)this.createButtonMove(composite, "arrowUp.svg", Messages.getString("MOVE_LEGEND_UP")));
        this.add((Control)this.createButtonMove(composite, "arrowDown.svg", Messages.getString("MOVE_LEGEND_DOWN")));
        this.add((Control)this.createButtonMove(composite, "arrowRight.svg", Messages.getString("MOVE_LEGEND_RIGHT")));
        this.textX = this.createTextPositionX(composite);
        this.add((Control)this.textX);
        this.textY = this.createTextPositionY(composite);
        this.add((Control)this.textY);
        this.add((Control)this.createButtonSetPosition(composite));
    }

    private void add(Control control) {
        this.controls.add(control);
    }

    private Button createButtonMove(Composite parent, final String icon, String tooltip) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(tooltip);
        button.setImage(ResourceSupport.getImage(icon));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                block16: {
                    if (InChartLegendUI.this.embeddedLegend == null) break block16;
                    int moveX = InChartLegendUI.this.preferenceStore != null ? InChartLegendUI.this.preferenceStore.getInt("moveLegendX") : 10;
                    int moveY = InChartLegendUI.this.preferenceStore != null ? InChartLegendUI.this.preferenceStore.getInt("moveLegendY") : 5;
                    int x = InChartLegendUI.this.embeddedLegend.getX();
                    int y = InChartLegendUI.this.embeddedLegend.getY();
                    switch (icon) {
                        case "arrowLeft.svg": {
                            x -= moveX;
                            break;
                        }
                        case "arrowUp.svg": {
                            y -= moveY;
                            break;
                        }
                        case "arrowDown.svg": {
                            y += moveY;
                            break;
                        }
                        case "arrowRight.svg": {
                            x += moveX;
                        }
                    }
                    InChartLegendUI.this.updateLegendPosition(x, y, true);
                }
            }
        });
        return button;
    }

    private Text createTextPositionX(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText(Messages.getString("LEGEND_POSITION_X"));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 60;
        text.setLayoutData((Object)gridData);
        final PositionValidator validator = new PositionValidator();
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (InChartLegendUI.this.validate(validator, controlDecoration, text) && InChartLegendUI.this.preferenceStore != null) {
                    InChartLegendUI.this.preferenceStore.setValue("legendPositionX", validator.getPosition());
                    ResourceSupport.savePreferenceStore();
                    InChartLegendUI.this.updateLegendPosition(true);
                }
            }
        });
        return text;
    }

    private Text createTextPositionY(Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText(Messages.getString("LEGEND_POSITION_Y"));
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 60;
        text.setLayoutData((Object)gridData);
        final PositionValidator validator = new PositionValidator();
        final ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (InChartLegendUI.this.validate(validator, controlDecoration, text) && InChartLegendUI.this.preferenceStore != null) {
                    InChartLegendUI.this.preferenceStore.setValue("legendPositionY", validator.getPosition());
                    ResourceSupport.savePreferenceStore();
                    InChartLegendUI.this.updateLegendPosition(true);
                }
            }
        });
        return text;
    }

    private Button createButtonSetPosition(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(Messages.getString("SET_LEGEND_POSITION"));
        button.setImage(ResourceSupport.getImage("position.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InChartLegendUI.this.capturePosition = MessageDialog.openConfirm((Shell)e.display.getActiveShell(), (String)Messages.getString("LEGEND_POSITION"), (String)Messages.getString("POSITION_USING_MOUSE"));
            }
        });
        return button;
    }

    private void updateLegendPosition(int x, int y, boolean redraw) {
        if (this.embeddedLegend != null) {
            this.embeddedLegend.setX(x);
            this.embeddedLegend.setY(y);
            if (this.preferenceStore != null) {
                this.preferenceStore.setValue("legendPositionX", x);
                this.preferenceStore.setValue("legendPositionY", y);
                ResourceSupport.savePreferenceStore();
            }
            this.textX.setText(Integer.toString(this.embeddedLegend.getX()));
            this.textY.setText(Integer.toString(this.embeddedLegend.getY()));
            if (this.scrollableChart != null && redraw) {
                this.scrollableChart.redraw();
            }
        }
    }

    private void updateLegendPosition(boolean redraw) {
        if (this.preferenceStore != null) {
            this.updateLegendPosition(this.preferenceStore.getInt("legendPositionX"), this.preferenceStore.getInt("legendPositionY"), redraw);
        }
    }

    private void createEmbeddedLegend() {
        if (this.scrollableChart != null) {
            BaseChart baseChart = this.scrollableChart.getBaseChart();
            this.embeddedLegend = new EmbeddedLegend(baseChart);
            this.embeddedLegend.setDraw(false);
            this.updateLegendPosition(false);
            baseChart.getPlotArea().addCustomPaintListener((ICustomPaintListener)this.embeddedLegend);
            baseChart.addCustomPointSelectionHandler(event -> {
                if (this.embeddedLegend.isDraw() && this.capturePosition) {
                    this.updateLegendPosition(event.x, event.y, true);
                    this.updateControls();
                    this.capturePosition = false;
                }
            });
        }
        this.updateControls();
    }

    private void updateControls() {
        if (this.embeddedLegend != null) {
            boolean enabled = this.embeddedLegend.isDraw();
            for (Control control : this.controls) {
                control.setEnabled(enabled);
            }
        }
    }

    private boolean validate(IValidator<String> validator, ControlDecoration controlDecoration, Text text) {
        IStatus status = validator.validate((Object)text.getText().trim());
        if (status.isOK()) {
            controlDecoration.hide();
            return true;
        }
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText(status.getMessage());
        controlDecoration.show();
        return false;
    }
}

