/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.internal;

import com.google.common.base.Joiner;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tea.core.internal.model.iface.TaskingContainer;
import org.eclipse.tea.core.internal.model.iface.TaskingElement;
import org.eclipse.tea.core.internal.model.iface.TaskingItem;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.ui.internal.TaskingImageHelper;

public class TaskingModelLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public StyledString getStyledText(Object element) {
        if (element instanceof TaskingContainer) {
            return new StyledString(((TaskingContainer)element).getLabel());
        }
        TaskingItem item = (TaskingItem)element;
        StyledString s = new StyledString(item.getLabel());
        TaskChain.TaskChainId id = item.getChain().getClass().getAnnotation(TaskChain.TaskChainId.class);
        if (id != null && id.alias().length != 0) {
            s.append(" - " + Joiner.on((String)", ").join((Object[])id.alias()), StyledString.DECORATIONS_STYLER);
        }
        return s.append(" - " + item.getChain().getClass().getName(), StyledString.QUALIFIER_STYLER);
    }

    public Image getImage(Object element) {
        TaskingElement te = (TaskingElement)element;
        return TaskingImageHelper.getSharedIcon(te.getIconBundle(), te.getIconPath());
    }
}

