/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.thread;

import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;
import jdk.test.lib.thread.TestThread;
import jdk.test.lib.thread.XRun;

public class ProcessThread
extends TestThread {
    public ProcessThread(String threadName, String ... cmd) {
        super(new ProcessRunnable(new ProcessBuilder(cmd)), threadName);
    }

    public ProcessThread(String threadName, ProcessBuilder pb) {
        super(new ProcessRunnable(pb), threadName);
    }

    public ProcessThread(String threadName, Predicate<String> waitfor, String ... cmd) {
        super(new ProcessRunnable(new ProcessBuilder(cmd), threadName, waitfor), threadName);
    }

    public ProcessThread(String threadName, Predicate<String> waitfor, ProcessBuilder pb) {
        super(new ProcessRunnable(pb, threadName, waitfor), threadName);
    }

    public void stopProcess() throws InterruptedException {
        ((ProcessRunnable)this.getRunnable()).stopProcess();
    }

    public OutputAnalyzer getOutput() {
        return ((ProcessRunnable)this.getRunnable()).getOutput();
    }

    public long getPid() throws InterruptedException {
        return ((ProcessRunnable)this.getRunnable()).getPid();
    }

    public void sendMessage(String message) throws InterruptedException {
        ((ProcessRunnable)this.getRunnable()).sendMessage(message);
    }

    static class ProcessRunnable
    extends XRun {
        private final ProcessBuilder processBuilder;
        private final CountDownLatch latch;
        private volatile Process process;
        private volatile OutputAnalyzer output;
        private final Predicate<String> waitfor;
        private final String name;

        public ProcessRunnable(ProcessBuilder pb) {
            this(pb, "", null);
        }

        public ProcessRunnable(ProcessBuilder pb, String name, Predicate<String> waitfor) {
            this.processBuilder = pb;
            this.latch = new CountDownLatch(1);
            this.name = name;
            this.waitfor = waitfor;
        }

        @Override
        public void xrun() throws Throwable {
            try {
                this.process = ProcessTools.startProcess(this.name, this.processBuilder, this.waitfor);
            }
            catch (Throwable t) {
                System.out.println(String.format("ProcessThread[%s] failed: %s", this.name, t.toString()));
                throw t;
            }
            finally {
                this.latch.countDown();
            }
            try {
                this.output = new OutputAnalyzer(this.process);
                this.process.waitFor();
            }
            catch (Throwable t) {
                System.out.println(String.format("ProcessThread[%s] failed: %s", this.name, t.toString()));
                throw t;
            }
            finally {
                this.process.destroyForcibly().waitFor();
                String logMsg = ProcessTools.getProcessLog(this.processBuilder, this.output);
                System.out.println(logMsg);
            }
        }

        public void stopProcess() throws InterruptedException {
            this.latch.await();
            if (this.process != null) {
                System.out.println("ProcessThread.stopProcess() will kill process");
                this.process.destroy();
            }
        }

        public OutputAnalyzer getOutput() {
            return this.output;
        }

        public long getPid() throws InterruptedException {
            return this.getProcess().pid();
        }

        public void sendMessage(String message) throws InterruptedException {
            try (PrintWriter pw = new PrintWriter(this.getProcess().getOutputStream());){
                pw.println(message);
                pw.flush();
            }
        }

        private Process getProcess() throws InterruptedException {
            this.latch.await();
            return this.process;
        }
    }
}

