/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Objects;

public class Asserts {
    public static <T extends Comparable<T>> void assertLT(T lhs, T rhs) {
        Asserts.assertLessThan(lhs, rhs);
    }

    public static <T extends Comparable<T>> void assertLT(T lhs, T rhs, String msg) {
        Asserts.assertLessThan(lhs, rhs, msg);
    }

    public static <T extends Comparable<T>> void assertLessThan(T lhs, T rhs) {
        Asserts.assertLessThan(lhs, rhs, null);
    }

    public static <T extends Comparable<T>> void assertLessThan(T lhs, T rhs, String msg) {
        if (Asserts.compare(lhs, rhs, (String)msg) >= 0) {
            msg = Objects.toString(msg, "assertLessThan") + ": expected that " + Objects.toString(lhs) + " < " + Objects.toString(rhs);
            Asserts.fail((String)msg);
        }
    }

    public static <T extends Comparable<T>> void assertLTE(T lhs, T rhs) {
        Asserts.assertLessThanOrEqual(lhs, rhs);
    }

    public static <T extends Comparable<T>> void assertLTE(T lhs, T rhs, String msg) {
        Asserts.assertLessThanOrEqual(lhs, rhs, msg);
    }

    public static <T extends Comparable<T>> void assertLessThanOrEqual(T lhs, T rhs) {
        Asserts.assertLessThanOrEqual(lhs, rhs, null);
    }

    public static <T extends Comparable<T>> void assertLessThanOrEqual(T lhs, T rhs, String msg) {
        if (Asserts.compare(lhs, rhs, (String)msg) > 0) {
            msg = Objects.toString(msg, "assertLessThanOrEqual") + ": expected that " + Objects.toString(lhs) + " <= " + Objects.toString(rhs);
            Asserts.fail((String)msg);
        }
    }

    public static void assertEQ(Object lhs, Object rhs) {
        Asserts.assertEquals(lhs, rhs);
    }

    public static void assertEQ(Object lhs, Object rhs, String msg) {
        Asserts.assertEquals(lhs, rhs, msg);
    }

    public static void assertEquals(Object lhs, Object rhs) {
        Asserts.assertEquals(lhs, rhs, null);
    }

    public static void assertEquals(Object lhs, Object rhs, String msg) {
        if (!(lhs == rhs || lhs != null && lhs.equals(rhs))) {
            Asserts.fail((msg == null ? "assertEquals" : msg) + " expected: " + String.valueOf(lhs) + " but was: " + String.valueOf(rhs));
        }
    }

    public static void assertSame(Object lhs, Object rhs) {
        Asserts.assertSame(lhs, rhs, null);
    }

    public static void assertSame(Object lhs, Object rhs, String msg) {
        if (lhs != rhs) {
            msg = Objects.toString(msg, "assertSame") + ": expected " + Objects.toString(lhs) + " to equal " + Objects.toString(rhs);
            Asserts.fail((String)msg);
        }
    }

    public static void assertEqualsByteArray(byte[] expected, byte[] actual) {
        Asserts.assertEqualsByteArray(expected, actual, null);
    }

    public static void assertNotEqualsByteArray(byte[] unexpected, byte[] actual) {
        Asserts.assertNotEqualsByteArray(unexpected, actual, null);
    }

    public static void assertEqualsByteArray(byte[] expected, byte[] actual, String msg) {
        if (!Arrays.equals(expected, actual)) {
            msg = Objects.toString(msg, "assertEqualsByteArray") + ": expected " + HexFormat.of().formatHex(expected) + " but was " + HexFormat.of().formatHex(actual);
            Asserts.fail((String)msg);
        }
    }

    public static void assertNotEqualsByteArray(byte[] unexpected, byte[] actual, String msg) {
        if (Arrays.equals(unexpected, actual)) {
            msg = Objects.toString(msg, "assertNotEqualsByteArray") + ": expected not equals but was " + HexFormat.of().formatHex(actual);
            Asserts.fail((String)msg);
        }
    }

    public static <T extends Comparable<T>> void assertGTE(T lhs, T rhs) {
        Asserts.assertGreaterThanOrEqual(lhs, rhs);
    }

    public static <T extends Comparable<T>> void assertGTE(T lhs, T rhs, String msg) {
        Asserts.assertGreaterThanOrEqual(lhs, rhs, msg);
    }

    public static <T extends Comparable<T>> void assertGreaterThanOrEqual(T lhs, T rhs) {
        Asserts.assertGreaterThanOrEqual(lhs, rhs, null);
    }

    public static <T extends Comparable<T>> void assertGreaterThanOrEqual(T lhs, T rhs, String msg) {
        if (Asserts.compare(lhs, rhs, (String)msg) < 0) {
            msg = Objects.toString(msg, "assertGreaterThanOrEqual") + ": expected " + Objects.toString(lhs) + " >= " + Objects.toString(rhs);
            Asserts.fail((String)msg);
        }
    }

    public static <T extends Comparable<T>> void assertGT(T lhs, T rhs) {
        Asserts.assertGreaterThan(lhs, rhs);
    }

    public static <T extends Comparable<T>> void assertGT(T lhs, T rhs, String msg) {
        Asserts.assertGreaterThan(lhs, rhs, msg);
    }

    public static <T extends Comparable<T>> void assertGreaterThan(T lhs, T rhs) {
        Asserts.assertGreaterThan(lhs, rhs, null);
    }

    public static <T extends Comparable<T>> void assertGreaterThan(T lhs, T rhs, String msg) {
        if (Asserts.compare(lhs, rhs, (String)msg) <= 0) {
            msg = Objects.toString(msg, "assertGreaterThan") + ": expected " + Objects.toString(lhs) + " > " + Objects.toString(rhs);
            Asserts.fail((String)msg);
        }
    }

    public static void assertNE(Object unexpected, Object actual) {
        Asserts.assertNotEquals(unexpected, actual);
    }

    public static void assertNE(Object unexpected, Object actual, String msg) {
        Asserts.assertNotEquals(unexpected, actual, msg);
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        Asserts.assertNotEquals(unexpected, actual, null);
    }

    public static void assertNotEquals(Object unexpected, Object actual, String msg) {
        if (unexpected == actual || unexpected != null && unexpected.equals(actual)) {
            msg = Objects.toString(msg, "assertNotEquals") + ": expected not equals but was " + Objects.toString(actual);
            Asserts.fail((String)msg);
        }
    }

    public static void assertNull(Object o) {
        Asserts.assertNull(o, null);
    }

    public static void assertNull(Object o, String msg) {
        Asserts.assertEquals(o, null, msg);
    }

    public static void assertNotNull(Object o) {
        Asserts.assertNotNull(o, null);
    }

    public static void assertNotNull(Object o, String msg) {
        Asserts.assertNotEquals(o, null, msg);
    }

    public static void assertFalse(boolean value) {
        Asserts.assertFalse(value, null);
    }

    public static void assertFalse(boolean value, String msg) {
        if (value) {
            msg = Objects.toString(msg, "assertFalse") + ": expected false, was true";
            Asserts.fail((String)msg);
        }
    }

    public static void assertTrue(boolean value) {
        Asserts.assertTrue(value, null);
    }

    public static void assertTrue(boolean value, String msg) {
        if (!value) {
            msg = Objects.toString(msg, "assertTrue") + ": expected true, was false";
            Asserts.fail((String)msg);
        }
    }

    private static <T extends Comparable<T>> int compare(T lhs, T rhs, String msg) {
        if (lhs == null || rhs == null) {
            Asserts.fail(lhs, rhs, msg + ": values must be non-null:", ",");
        }
        return lhs.compareTo(rhs);
    }

    public static void assertStringsEqual(String str1, String str2, String msg) {
        String[] str2Lines;
        int minLength;
        String lineSeparator = System.getProperty("line.separator");
        String[] str1Lines = str1.split(lineSeparator);
        String[] longestStringLines = str1Lines.length == (minLength = Math.min(str1Lines.length, (str2Lines = str2.split(lineSeparator)).length)) ? str2Lines : str1Lines;
        boolean stringsAreDifferent = false;
        StringBuilder messageBuilder = new StringBuilder(msg);
        messageBuilder.append("\n");
        for (int line = 0; line < minLength; ++line) {
            if (str1Lines[line].equals(str2Lines[line])) continue;
            messageBuilder.append(String.format("[line %d] '%s' differs from '%s'\n", line, str1Lines[line], str2Lines[line]));
            stringsAreDifferent = true;
        }
        if (minLength < longestStringLines.length) {
            String stringName = longestStringLines == str1Lines ? "first" : "second";
            messageBuilder.append(String.format("Only %s string contains following lines:\n", stringName));
            stringsAreDifferent = true;
            for (int line = minLength; line < longestStringLines.length; ++line) {
                messageBuilder.append(String.format("[line %d] '%s'", line, longestStringLines[line]));
            }
        }
        if (stringsAreDifferent) {
            Asserts.fail(messageBuilder.toString());
        }
    }

    public static void assertFileContentsEqual(Path f1, Path f2) {
        long mismatchIndex = 0L;
        try {
            mismatchIndex = Files.mismatch(f1, f2);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
        if (mismatchIndex >= 0L) {
            String message = String.format("Contents of files '%s' and '%s' mismatch at index %d", f1, f2, mismatchIndex);
            Asserts.fail(message);
        }
    }

    public static <T extends Throwable> T assertThrows(Class<T> expected, TestMethod testMethod) {
        return Asserts.assertThrows(expected, testMethod, "An unexpected exception was thrown.");
    }

    public static <T extends Throwable> T assertThrows(Class<T> expected, TestMethod testMethod, String msg) {
        try {
            testMethod.execute();
        }
        catch (Throwable exc) {
            if (expected.isInstance(exc)) {
                return (T)((Throwable)expected.cast(exc));
            }
            Asserts.fail(Objects.toString(msg, "An unexpected exception was thrown.") + " Expected " + expected.getName(), exc);
        }
        throw new RuntimeException("No exception was thrown. Expected: " + expected.getName());
    }

    public static String format(Object lhs, Object rhs, String message, String relation) {
        StringBuilder sb = new StringBuilder(80);
        if (message != null) {
            sb.append(message);
            sb.append(' ');
        }
        sb.append("<");
        sb.append(Objects.toString(lhs));
        sb.append("> ");
        sb.append(Objects.toString(relation, ","));
        sb.append(" <");
        sb.append(Objects.toString(rhs));
        sb.append(">");
        return sb.toString();
    }

    public static void fail() {
        Asserts.fail("fail");
    }

    public static void fail(String message) {
        throw new RuntimeException(message);
    }

    public static void fail(Object lhs, Object rhs, String message, String relation) {
        throw new RuntimeException(Asserts.format(lhs, rhs, message, relation));
    }

    public static void fail(String message, Throwable cause) {
        throw new RuntimeException(message, cause);
    }

    @FunctionalInterface
    public static interface TestMethod {
        public void execute() throws Throwable;
    }
}

